/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.date;

import java.util.Calendar;
import java.util.Date;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.function.date.DateEnum;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class DateTruncFunction
extends AbstractScriptFunction {
    @Override
    public String getNames() {
        return "dateTrunc";
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            DateEnum datePart = null;
            Calendar cal = Calendar.getInstance();
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
            }
            if (!this.checkParameters(parameters, 2)) {
                throw new NotMatchException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
            }
            datePart = DateEnum.valueOf(((String)parameters[0]).toUpperCase());
            Date date = (Date)parameters[1];
            cal.setTime(date);
            switch (datePart) {
                case WEEK: {
                    Calendar start = Calendar.getInstance();
                    start.setTime(new Date());
                    start.set(2, 0);
                    start.set(5, 1);
                    if (start.get(7) != 1) {
                        start.set(5, 9 - start.get(7));
                    }
                    return start.getTime();
                }
                case WEEKDAY: {
                    if (cal.get(7) != 1) {
                        cal.set(5, cal.get(5) - cal.get(7) + 1);
                    }
                    return cal.getTime();
                }
                case YEAR: 
                case MONTH: {
                    cal.set(2, 0);
                }
                case DAY: {
                    cal.set(5, 1);
                }
                case HOUR: {
                    cal.set(10, 0);
                }
                case MINUTE: {
                    cal.set(12, 0);
                }
                case SECOND: {
                    cal.set(13, 0);
                    return cal.getTime();
                }
            }
            return null;
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }
}

