/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    private static final List<String> weekDays = new ArrayList<String>();

    public static String getWeekday(int index) {
        return weekDays.get(index);
    }

    public static int getWeekDay(String weekDay) {
        return weekDays.indexOf(weekDay);
    }

    public static int countWeekDiff(Calendar c1, Calendar c2, String startWeekDay) {
        int diffWeeks = 0;
        String string = startWeekDay = startWeekDay == null ? "sunday" : startWeekDay;
        if (c1.get(7) > 1 + DateUtil.getWeekDay(startWeekDay)) {
            c1.set(5, c1.get(5) + 8 - c1.get(7) + DateUtil.getWeekDay(startWeekDay));
            if (c1.getTimeInMillis() <= c2.getTimeInMillis()) {
                diffWeeks = 1;
            }
        } else if (c1.get(7) < 1 + DateUtil.getWeekDay(startWeekDay)) {
            c1.set(5, c1.get(5) + 1 - c1.get(7) + DateUtil.getWeekDay(startWeekDay));
            if (c1.getTimeInMillis() <= c2.getTimeInMillis()) {
                diffWeeks = 1;
            }
        }
        if (c1.getTimeInMillis() > c2.getTimeInMillis()) {
            return diffWeeks;
        }
        int daysDiff = (int)((c2.getTimeInMillis() - c1.getTimeInMillis()) / 86400000L);
        return daysDiff / 7 + diffWeeks;
    }

    public static Date convertDateByString(String s, String rule) throws ParseException {
        SimpleDateFormat format = rule != null ? new SimpleDateFormat(rule) : new SimpleDateFormat();
        return format.parse(s);
    }

    public static String dateToString(Date date, String rule) {
        SimpleDateFormat dateFormat = rule != null ? new SimpleDateFormat(rule) : new SimpleDateFormat();
        return dateFormat.format(date);
    }

    static {
        weekDays.add("sunday");
        weekDays.add("monday");
        weekDays.add("tuesday");
        weekDays.add("wednesday");
        weekDays.add("thursday");
        weekDays.add("friday");
        weekDays.add("saturday");
    }
}

