/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.date;

import java.util.Calendar;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class MakeDateFunction
extends AbstractScriptFunction {
    @Override
    public String getNames() {
        return "makeDate";
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            Calendar cal = Calendar.getInstance();
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
            }
            if (this.checkParameters(parameters, 3)) {
                int year = ExpressionUtil.convertInteger(parameters[0]);
                int month = ExpressionUtil.convertInteger(parameters[1]);
                int day = ExpressionUtil.convertInteger(parameters[2]);
                cal.set(1, year);
                cal.set(2, month - 1);
                cal.set(5, day);
                return cal.getTime();
            }
            throw new NotMatchException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }
}

