/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.math;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public abstract class AbstractMathCollectionFunction
extends AbstractScriptFunction {
    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
            }
            if (parameters.length == this.getParameterCount()) {
                return this.compute(parameters);
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }

    protected abstract int getParameterCount();

    protected int getCollectionSize(Object ... parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (!ExpressionUtil.isCollection(parameters[i])) continue;
            List<Object> list = ExpressionUtil.convertCollection(parameters[i]);
            return list.size();
        }
        return -1;
    }

    protected Object compute(Object ... parameters) throws ScriptException {
        int size = this.getCollectionSize(parameters);
        if (size < 0) {
            return this.computeItem(parameters);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        FunctionParameter functionParameter = new FunctionParameter(parameters);
        for (int i = 0; i < size; ++i) {
            result.add(this.compute(functionParameter.getNewParameters(i)));
        }
        return result;
    }

    protected abstract Object computeItem(Object ... var1) throws ScriptException;

    class FunctionParameter {
        Object[] array;

        public FunctionParameter(Object ... parameters) {
            this.array = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.array[i] = ExpressionUtil.isCollection(parameters[i]) ? ExpressionUtil.convertCollection(parameters[i]) : parameters[i];
            }
        }

        private Object getValue(int i, int j) {
            if (this.array[i] instanceof List) {
                List list = (List)this.array[i];
                return list.get(j);
            }
            return this.array[i];
        }

        public Object[] getNewParameters(int p) {
            Object[] parameters = new Object[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                parameters[i] = this.getValue(i, p);
            }
            return parameters;
        }
    }
}

