/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.math;

import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.function.math.AbstractMathCollectionFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class MathAbsFunction
extends AbstractMathCollectionFunction {
    @Override
    public String getNames() {
        return "abs";
    }

    @Override
    protected int getParameterCount() {
        return 1;
    }

    @Override
    protected Object computeItem(Object ... parameters) throws ScriptException {
        Object value = parameters[0];
        if (value instanceof Double) {
            return Math.abs((Double)value);
        }
        if (value instanceof Float) {
            return Float.valueOf(Math.abs(((Float)value).floatValue()));
        }
        if (value instanceof Integer) {
            return Math.abs((Integer)value);
        }
        if (value instanceof Long) {
            return Math.abs((Long)value);
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.unsupport", this.getNames(), value.getClass().getName()));
    }
}

