/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.math;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.function.DynamicNameScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;

public class MathAggregateFunction
extends DynamicNameScriptFunction {
    @Override
    public boolean enableExpressionParameter() {
        return true;
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        String functionName = ScriptContextUtil.getDynamicFunctionName(context);
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", functionName));
            }
            if (this.checkParameters(parameters, 1)) {
                Object p = this.getValue(parameters[0]);
                ArrayList<Object> parameterList = new ArrayList<Object>();
                if (ExpressionUtil.isCollection(p)) {
                    parameterList = ExpressionUtil.convertCollection(p);
                } else {
                    parameterList.add(p);
                }
                return ExpressionUtil.compute(functionName, parameterList, new Object[0]);
            }
            if (parameters.length > 1 && ExpressionUtil.isCollection(this.getValue(parameters[0]))) {
                Object[] newParams = this.subArray(parameters, 1);
                return ExpressionUtil.compute(functionName, ExpressionUtil.convertCollection(this.getValue(parameters[0])), newParams);
            }
            ArrayList<Object> parameterList = new ArrayList<Object>();
            for (Object parameter : parameters) {
                Object v = this.getValue(parameter);
                if (v == null) continue;
                parameterList.add(v);
            }
            return ExpressionUtil.compute(functionName, parameterList, new Object[0]);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", functionName), e);
        }
    }

    @Override
    public boolean exsitFunctionName(String name) {
        return ExpressionUtil.getNumberCalculator(name) != null;
    }

    @Override
    public List<String> getFunctionNames() {
        return ExpressionUtil.getCalculatorNames();
    }
}

