/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.math;

import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.function.math.AbstractMathCollectionFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class MathCeilFunction
extends AbstractMathCollectionFunction {
    @Override
    public String getNames() {
        return "ceil";
    }

    @Override
    protected int getParameterCount() {
        return 1;
    }

    @Override
    protected Object computeItem(Object ... parameters) throws ScriptException {
        Object value = parameters[0];
        if (value instanceof Double) {
            return Math.ceil((Double)value);
        }
        if (value instanceof Float) {
            Double d = Math.ceil(((Float)value).floatValue());
            return Float.valueOf(d.floatValue());
        }
        if (value instanceof Integer) {
            Double d = Math.ceil(((Integer)value).intValue());
            return d.intValue();
        }
        if (value instanceof Long) {
            Double d = Math.ceil(((Long)value).longValue());
            return d.longValue();
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.unsupport", this.getNames(), value.getClass().getName()));
    }
}

