/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.math;

import java.math.BigDecimal;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.function.math.AbstractMathCollectionFunction;

public class MathRoundFunction
extends AbstractMathCollectionFunction {
    @Override
    public String getNames() {
        return "round";
    }

    @Override
    protected int getParameterCount() {
        return 2;
    }

    @Override
    protected Object computeItem(Object ... parameters) throws ScriptException {
        if (parameters[0] instanceof Float) {
            int s = ExpressionUtil.convertInteger(parameters[1]);
            BigDecimal number = new BigDecimal(((Float)parameters[0]).floatValue());
            return Float.valueOf(number.setScale(s, 4).floatValue());
        }
        if (parameters[0] instanceof Double) {
            int s = ExpressionUtil.convertInteger(parameters[1]);
            BigDecimal number = new BigDecimal((Double)parameters[0]);
            return number.setScale(s, 4).doubleValue();
        }
        if (parameters[0] instanceof BigDecimal) {
            int s = ExpressionUtil.convertInteger(parameters[1]);
            BigDecimal number = (BigDecimal)parameters[0];
            return number.setScale(s, 4);
        }
        return parameters[0];
    }
}

