/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.output;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.DynamicNameScriptFunction;
import org.tinygroup.tinyscript.interpret.FunctionCallUtil;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;

public class LoggerFunction
extends DynamicNameScriptFunction {
    private static final Set<String> names = new HashSet<String>();
    private static final Logger logger = LoggerFactory.getLogger((String)"tinyscript");

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        String functionName = ScriptContextUtil.getDynamicFunctionName(context);
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", functionName));
            }
            if (parameters != null && parameters.length >= 1 && parameters[0] instanceof String) {
                ScriptClassInstance scriptClassInstance = ScriptContextUtil.getScriptClassInstance(context);
                if (scriptClassInstance != null) {
                    parameters[0] = String.format("[%s] ", scriptClassInstance.getScriptClass().getClassName()) + parameters[0];
                }
                return FunctionCallUtil.operate(segment, context, logger, functionName, parameters);
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", functionName));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", functionName), e);
        }
    }

    @Override
    public boolean exsitFunctionName(String name) {
        return names.contains(name);
    }

    @Override
    public List<String> getFunctionNames() {
        return new ArrayList<String>(names);
    }

    static {
        names.add("trace");
        names.add("debug");
        names.add("info");
        names.add("warn");
        names.add("error");
    }
}

