/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.random;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.call.JavaMethodUtil;

public class ArrayRandFunction
extends AbstractScriptFunction {
    @Override
    public String getNames() {
        return "randArray";
    }

    @Override
    public boolean enableExpressionParameter() {
        return true;
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
            }
            if (this.checkParameters(parameters, 1)) {
                Object obj = this.getValue(parameters[0]);
                if (obj.getClass().isArray()) {
                    return this.randArray(obj, 1);
                }
                if (obj instanceof Collection) {
                    return this.randCollection((Collection)obj, 1, false);
                }
            } else if (this.checkParameters(parameters, 2)) {
                Object obj = this.getValue(parameters[0]);
                int num = (Integer)this.getValue(parameters[1]);
                if (obj.getClass().isArray()) {
                    return this.randArray(obj, num);
                }
                if (obj instanceof Collection) {
                    return this.randCollection((Collection)obj, num, false);
                }
            } else if (this.checkParameters(parameters, 3)) {
                Object obj = this.getValue(parameters[0]);
                int num = (Integer)this.getValue(parameters[1]);
                boolean variable = (Boolean)this.getValue(parameters[2]);
                if (obj.getClass().isArray()) {
                    if (variable) {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.randarray.unsupport"));
                    }
                    return this.randArray(obj, num);
                }
                if (obj instanceof Collection) {
                    return this.randCollection((Collection)obj, num, variable);
                }
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }

    private Object randArray(Object array, int num) throws Exception {
        int length = Array.getLength(array);
        if (length > 0 && num > 0) {
            Random r = new Random();
            if (num == 1) {
                return Array.get(array, r.nextInt(length));
            }
            if (num <= length) {
                HashMap<Integer, Object> map = new HashMap<Integer, Object>();
                while (map.size() < num) {
                    int p = r.nextInt(length);
                    map.put(p, Array.get(array, p));
                }
                return map.values().toArray();
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.randarray.error", num, length));
        }
        return null;
    }

    private Object randCollection(Collection collection, int num, boolean variable) throws Exception {
        int size = collection.size();
        if (size > 0 && num > 0) {
            ArrayList list = new ArrayList(collection);
            Random r = new Random();
            if (num == 1) {
                int p = r.nextInt(size);
                Object obj = list.get(p);
                if (variable) {
                    list.remove(p);
                }
                return obj;
            }
            if (num <= size) {
                HashMap map = new HashMap();
                Collection result = (Collection)JavaMethodUtil.clone(collection);
                result.clear();
                while (map.size() < num) {
                    int p = r.nextInt(size);
                    map.put(p, list.get(p));
                }
                result.addAll(map.values());
                if (variable) {
                    collection.removeAll(result);
                }
                return result;
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.randarray.error", num, size));
        }
        return null;
    }
}

