/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.context.Context;
import org.tinygroup.tinyscript.ScriptClass;
import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptClassMethod;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.impl.DefaultScriptContext;
import org.tinygroup.tinyscript.impl.ScriptMethodContext;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptUtil;

public abstract class AbstractScriptEngine
implements ScriptEngine {
    private String defaultEncode;
    private boolean enableCache = true;
    private boolean indexFromOne = false;
    private Map<Object, ScriptSegment> segmentCaches = new HashMap<Object, ScriptSegment>();
    private ScriptInterpret scriptInterpret;
    private ScriptContext scriptContext;

    public AbstractScriptEngine() {
        this.scriptContext = new DefaultScriptContext();
    }

    public AbstractScriptEngine(Map<?, ?> map) {
        this.scriptContext = new DefaultScriptContext(map);
    }

    @Override
    public String getEncode() {
        return this.defaultEncode == null ? "utf-8" : this.defaultEncode;
    }

    @Override
    public void setEncode(String encode) {
        this.defaultEncode = encode;
    }

    @Override
    public boolean isEnableCache() {
        return this.enableCache;
    }

    @Override
    public void setEnableCache(boolean tag) {
        this.enableCache = tag;
    }

    @Override
    public boolean isIndexFromOne() {
        return this.indexFromOne;
    }

    @Override
    public void setIndexFromOne(boolean tag) {
        this.indexFromOne = tag;
    }

    @Override
    public void addScriptSegment(ScriptSegment segment) {
        this.segmentCaches.put(segment.getSegmentId(), segment);
    }

    @Override
    public void removeScriptSegment(ScriptSegment segment) {
        this.segmentCaches.remove(segment.getSegmentId());
    }

    @Override
    public ScriptSegment getScriptSegment(String segmentId) {
        return this.segmentCaches.get(segmentId);
    }

    @Override
    public ScriptContext getScriptContext() {
        return this.scriptContext;
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context) throws ScriptException {
        ScriptContext nowContext = context;
        Context parentContext = nowContext.getParent();
        while (parentContext != null) {
            nowContext = parentContext;
            parentContext = nowContext.getParent();
        }
        if (!nowContext.equals(this.scriptContext)) {
            nowContext.setParent(this.scriptContext);
        }
        return segment.execute(context);
    }

    @Override
    public Object execute(ScriptSegment segment) throws ScriptException {
        DefaultScriptContext runContext = new DefaultScriptContext();
        runContext.setParent(this.scriptContext);
        return this.execute(segment, (ScriptContext)runContext);
    }

    @Override
    public Object execute(String script, ScriptContext context) throws ScriptException {
        ScriptSegment segment = this.findScriptSegment(script);
        return this.execute(segment, context);
    }

    @Override
    public Object execute(String script) throws ScriptException {
        DefaultScriptContext runContext = new DefaultScriptContext();
        runContext.setParent(this.scriptContext);
        return this.execute(script, (ScriptContext)runContext);
    }

    @Override
    public ScriptSegment findScriptSegment(Object queryRule) throws ScriptException {
        if (this.enableCache) {
            ScriptSegment segment = this.segmentCaches.get(queryRule);
            if (segment != null) {
                return segment;
            }
            segment = this.findScriptSegmentWithoutCache(queryRule);
            if (segment != null) {
                this.segmentCaches.put(queryRule, segment);
            }
            return segment;
        }
        return this.findScriptSegmentWithoutCache(queryRule);
    }

    @Override
    public void stop() throws ScriptException {
        this.segmentCaches.clear();
    }

    public ScriptInterpret getScriptInterpret() {
        if (this.scriptInterpret == null) {
            return ScriptUtil.getDefault();
        }
        return this.scriptInterpret;
    }

    public void setScriptInterpret(ScriptInterpret interpret) {
        this.scriptInterpret = interpret;
    }

    @Override
    public Object execute(String className, String methodName, Object ... parameters) throws ScriptException {
        ScriptClass scriptClass = this.findScriptClass(className);
        ScriptMethodContext context = new ScriptMethodContext();
        context.setParent(this.scriptContext);
        ScriptClassInstance classInstance = scriptClass.newInstance(context, new Object[0]);
        ScriptContextUtil.setScriptClassInstance(context, classInstance);
        return classInstance.execute(context, methodName, parameters);
    }

    @Override
    public Object execute(Map<String, Object> maps, String className, String methodName) throws ScriptException {
        ScriptClass scriptClass = this.findScriptClass(className);
        ScriptClassMethod scriptClassMethod = scriptClass.getScriptMethod(methodName);
        if (scriptClassMethod == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.notfind.scriptclassmethod", className, methodName));
        }
        String[] names = scriptClassMethod.getParamterNames();
        Object[] parameters = new Object[names == null ? 0 : names.length];
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                parameters[i] = maps.get(names[i]);
            }
        }
        ScriptMethodContext context = new ScriptMethodContext();
        context.setParent(this.scriptContext);
        ScriptClassInstance classInstance = scriptClass.newInstance(context, new Object[0]);
        ScriptContextUtil.setScriptClassInstance(context, classInstance);
        return classInstance.execute(context, methodName, parameters);
    }

    private ScriptClass findScriptClass(String className) throws ScriptException {
        ScriptSegment segment = this.findScriptSegment(className);
        if (segment == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.notfind.segment", className));
        }
        ScriptClass scriptClass = segment.getScriptClass();
        if (scriptClass == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.undefine.scriptclass", className));
        }
        return scriptClass;
    }

    protected abstract ScriptSegment findScriptSegmentWithoutCache(Object var1) throws ScriptException;
}

