/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.tinyscript.ScriptContext;

public class ArrayScriptContext
extends ContextImpl
implements ScriptContext {
    private static final long serialVersionUID = -8021808644510481934L;
    private int length = -1;
    private int order = -1;

    public ArrayScriptContext(Context context, int length) {
        this.setParent(context);
        this.setLength(length);
    }

    public Integer[] getDimsFromRoot() {
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        ArrayScriptContext parent = this;
        while (parent != null && parent.getOrder() >= 0) {
            dimList.add(0, parent.getOrder());
            parent = this.getParent(parent);
        }
        Integer[] dims = new Integer[dimList.size()];
        return dimList.toArray(dims);
    }

    private ArrayScriptContext getParent(ArrayScriptContext context) {
        Context parent = context.getParent();
        if (parent instanceof ArrayScriptContext) {
            return (ArrayScriptContext)parent;
        }
        return null;
    }

    public Integer[] getDimsToLeaf() {
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        this.dealDimList(dimList, this);
        Integer[] dims = new Integer[dimList.size()];
        return dimList.toArray(dims);
    }

    private void dealDimList(List<Integer> dimList, ArrayScriptContext context) {
        dimList.add(context.getLength());
        Map subContexts = context.getSubContextMap();
        if (!subContexts.isEmpty()) {
            ArrayScriptContext maxLengthContext = null;
            for (Context sub : subContexts.values()) {
                ArrayScriptContext subArray = (ArrayScriptContext)sub;
                if (maxLengthContext == null) {
                    maxLengthContext = subArray;
                    continue;
                }
                if (maxLengthContext.getLength() >= subArray.getLength()) continue;
                maxLengthContext = subArray;
            }
            this.dealDimList(dimList, maxLengthContext);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Iterator<Element> iterator() {
        ArrayList<Element> elementList = new ArrayList<Element>();
        this.addElements(elementList, this);
        return elementList.iterator();
    }

    protected void addElements(List<Element> elementList, ArrayScriptContext context) {
        elementList.addAll(context.getElements());
        Map subContexts = context.getSubContextMap();
        if (!subContexts.isEmpty()) {
            for (Context subContext : subContexts.values()) {
                ArrayScriptContext arrayScriptContext = (ArrayScriptContext)subContext;
                arrayScriptContext.addElements(elementList, arrayScriptContext);
            }
        }
    }

    protected List<Element> getElements() {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Integer[] dims = this.getDimsFromRoot();
        for (Map.Entry entry : this.getItemMap().entrySet()) {
            int index = Integer.parseInt((String)entry.getKey());
            ObjectElement element = new ObjectElement(dims, index, entry.getValue());
            elementList.add(element);
        }
        return elementList;
    }

    public boolean exist(String name) {
        return this.getItemMap().containsKey(name);
    }

    public <T> T get(String name) {
        return (T)this.getItemMap().get(name);
    }

    class ObjectElement
    implements Element {
        private Integer[] items;
        private int index;
        private Object value;

        public ObjectElement(Integer[] items, int index, Object value) {
            this.items = items;
            this.index = index;
            this.value = value;
        }

        @Override
        public Integer[] getItems() {
            return this.items;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static interface Element {
        public Integer[] getItems();

        public int getIndex();

        public Object getValue();
    }
}

