/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptFunction;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.config.FunctionConfig;
import org.tinygroup.tinyscript.function.AnalysisModelFunction;
import org.tinygroup.tinyscript.function.ContextToBeanFunction;
import org.tinygroup.tinyscript.function.DynamicNameScriptFunction;
import org.tinygroup.tinyscript.function.EvalScriptFunction;
import org.tinygroup.tinyscript.function.TypeConvertFunction;
import org.tinygroup.tinyscript.function.date.ClearTimeFunction;
import org.tinygroup.tinyscript.function.date.DateAddFunction;
import org.tinygroup.tinyscript.function.date.DateDifferentFunction;
import org.tinygroup.tinyscript.function.date.DateNameFunction;
import org.tinygroup.tinyscript.function.date.DatePartFunction;
import org.tinygroup.tinyscript.function.date.DateToStringFunction;
import org.tinygroup.tinyscript.function.date.DateTruncFunction;
import org.tinygroup.tinyscript.function.date.DayFunction;
import org.tinygroup.tinyscript.function.date.EqualsDateFunction;
import org.tinygroup.tinyscript.function.date.MakeDateFunction;
import org.tinygroup.tinyscript.function.date.MakeDateTime;
import org.tinygroup.tinyscript.function.date.MonthFunction;
import org.tinygroup.tinyscript.function.date.NowFunction;
import org.tinygroup.tinyscript.function.date.TodayFunction;
import org.tinygroup.tinyscript.function.date.YearFunction;
import org.tinygroup.tinyscript.function.locale.SetLocaleFunction;
import org.tinygroup.tinyscript.function.math.MathAbsFunction;
import org.tinygroup.tinyscript.function.math.MathAcosFunction;
import org.tinygroup.tinyscript.function.math.MathAggregateFunction;
import org.tinygroup.tinyscript.function.math.MathAsinFunction;
import org.tinygroup.tinyscript.function.math.MathAtan2Function;
import org.tinygroup.tinyscript.function.math.MathAtanFunction;
import org.tinygroup.tinyscript.function.math.MathCeilFunction;
import org.tinygroup.tinyscript.function.math.MathCosFunction;
import org.tinygroup.tinyscript.function.math.MathCotFunction;
import org.tinygroup.tinyscript.function.math.MathDegreesFunction;
import org.tinygroup.tinyscript.function.math.MathExpFunction;
import org.tinygroup.tinyscript.function.math.MathFloorFunction;
import org.tinygroup.tinyscript.function.math.MathLnFunction;
import org.tinygroup.tinyscript.function.math.MathLogFunction;
import org.tinygroup.tinyscript.function.math.MathPowFunction;
import org.tinygroup.tinyscript.function.math.MathRadiansFunction;
import org.tinygroup.tinyscript.function.math.MathRoundFunction;
import org.tinygroup.tinyscript.function.math.MathSignFunction;
import org.tinygroup.tinyscript.function.math.MathSinFunction;
import org.tinygroup.tinyscript.function.math.MathSqrtFunction;
import org.tinygroup.tinyscript.function.math.MathTanFunction;
import org.tinygroup.tinyscript.function.output.ConsolePrintFunction;
import org.tinygroup.tinyscript.function.output.ConsolePrintfFunction;
import org.tinygroup.tinyscript.function.output.ConsolePrintlnFunction;
import org.tinygroup.tinyscript.function.output.LoggerFunction;
import org.tinygroup.tinyscript.function.random.ArrayRandFunction;
import org.tinygroup.tinyscript.function.random.DoubleRandFunction;
import org.tinygroup.tinyscript.function.random.FloatRandFunction;
import org.tinygroup.tinyscript.function.random.IntRandFunction;
import org.tinygroup.tinyscript.function.random.LongRandFunction;
import org.tinygroup.tinyscript.function.string.NumberToCharFunction;
import org.tinygroup.tinyscript.function.string.StringAsciiFunction;
import org.tinygroup.tinyscript.function.string.StringLCSFunction;
import org.tinygroup.tinyscript.function.string.StringRepeatFunction;
import org.tinygroup.tinyscript.function.string.StringSubRightFunction;
import org.tinygroup.tinyscript.impl.AbstractScriptEngine;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;

public class DefaultScriptEngine
extends AbstractScriptEngine {
    private Map<String, ScriptFunction> functionMap = new HashMap<String, ScriptFunction>();
    private Map<Class<?>, Map<String, ScriptFunction>> typeFunctionMap = new HashMap();
    private List<DynamicNameScriptFunction> dynamicList = new ArrayList<DynamicNameScriptFunction>();
    private Map<Class<?>, List<DynamicNameScriptFunction>> typeDynamicMap = new HashMap();
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultScriptEngine.class);

    public DefaultScriptEngine() throws ScriptException {
        this.initScriptEngine();
    }

    public DefaultScriptEngine(Map<?, ?> map) throws ScriptException {
        super(map);
        this.initScriptEngine();
    }

    private void initScriptEngine() throws ScriptException {
        this.addScriptFunction(new MathAbsFunction());
        this.addScriptFunction(new MathAcosFunction());
        this.addScriptFunction(new MathAsinFunction());
        this.addScriptFunction(new MathAtanFunction());
        this.addScriptFunction(new MathCosFunction());
        this.addScriptFunction(new MathSinFunction());
        this.addScriptFunction(new MathTanFunction());
        this.addScriptFunction(new MathSqrtFunction());
        this.addScriptFunction(new MathPowFunction());
        this.addScriptFunction(new MathRoundFunction());
        this.addScriptFunction(new MathCeilFunction());
        this.addScriptFunction(new MathFloorFunction());
        this.addScriptFunction(new MathSignFunction());
        this.addScriptFunction(new MathLogFunction());
        this.addScriptFunction(new MathRadiansFunction());
        this.addScriptFunction(new MathLnFunction());
        this.addScriptFunction(new MathExpFunction());
        this.addScriptFunction(new MathDegreesFunction());
        this.addScriptFunction(new MathCotFunction());
        this.addScriptFunction(new MathAtan2Function());
        this.addScriptFunction(new MathAggregateFunction());
        this.addScriptFunction(new ClearTimeFunction());
        this.addScriptFunction(new DateAddFunction());
        this.addScriptFunction(new DateNameFunction());
        this.addScriptFunction(new DatePartFunction());
        this.addScriptFunction(new DateTruncFunction());
        this.addScriptFunction(new DayFunction());
        this.addScriptFunction(new MakeDateFunction());
        this.addScriptFunction(new MakeDateTime());
        this.addScriptFunction(new MonthFunction());
        this.addScriptFunction(new NowFunction());
        this.addScriptFunction(new TodayFunction());
        this.addScriptFunction(new YearFunction());
        this.addScriptFunction(new EqualsDateFunction());
        this.addScriptFunction(new DateDifferentFunction());
        this.addScriptFunction(new DateToStringFunction());
        this.addScriptFunction(new TypeConvertFunction());
        this.addScriptFunction(new EvalScriptFunction());
        this.addScriptFunction(new AnalysisModelFunction());
        this.addScriptFunction(new DoubleRandFunction());
        this.addScriptFunction(new FloatRandFunction());
        this.addScriptFunction(new IntRandFunction());
        this.addScriptFunction(new LongRandFunction());
        this.addScriptFunction(new ArrayRandFunction());
        this.addScriptFunction(new ConsolePrintFunction());
        this.addScriptFunction(new ConsolePrintfFunction());
        this.addScriptFunction(new ConsolePrintlnFunction());
        this.addScriptFunction(new LoggerFunction());
        this.addScriptFunction(new SetLocaleFunction());
        this.addScriptFunction(new ContextToBeanFunction());
        this.addScriptFunction(new StringAsciiFunction());
        this.addScriptFunction(new NumberToCharFunction());
        this.addScriptFunction(new StringRepeatFunction());
        this.addScriptFunction(new StringSubRightFunction());
        this.addScriptFunction(new StringLCSFunction());
        this.getScriptContext().put("PI", Math.PI);
        this.getScriptContext().put("E", Math.E);
        ScriptContextUtil.setScriptEngine(this.getScriptContext(), this);
    }

    @Override
    public void addScriptFunction(ScriptFunction function) throws ScriptException {
        block14: {
            block12: {
                String[] types;
                DynamicNameScriptFunction dynamicNameScriptFunction;
                block13: {
                    function.setScriptEngine(this);
                    if (!(function instanceof DynamicNameScriptFunction)) break block12;
                    dynamicNameScriptFunction = (DynamicNameScriptFunction)function;
                    if (function.getBindingTypes() != null) break block13;
                    if (this.dynamicList.contains(dynamicNameScriptFunction)) break block14;
                    this.dynamicList.add(dynamicNameScriptFunction);
                    break block14;
                }
                for (String type : types = function.getBindingTypes().split(",")) {
                    try {
                        Class<?> clazz = Class.forName(type);
                        List<DynamicNameScriptFunction> dynamicNameList = this.typeDynamicMap.get(clazz);
                        if (dynamicNameList == null) {
                            dynamicNameList = new ArrayList<DynamicNameScriptFunction>();
                            this.typeDynamicMap.put(clazz, dynamicNameList);
                        }
                        if (dynamicNameList.contains(dynamicNameScriptFunction)) continue;
                        dynamicNameList.add(dynamicNameScriptFunction);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.notfind.class1", type), e);
                    }
                }
                break block14;
            }
            String[] names = function.getNames().split(",");
            if (function.getBindingTypes() == null) {
                for (String name : names) {
                    this.functionMap.put(name, function);
                }
            } else {
                String[] types;
                for (String type : types = function.getBindingTypes().split(",")) {
                    try {
                        Class<?> clazz = Class.forName(type);
                        Map<String, ScriptFunction> nameMap = this.typeFunctionMap.get(clazz);
                        if (nameMap == null) {
                            nameMap = new HashMap<String, ScriptFunction>();
                            this.typeFunctionMap.put(clazz, nameMap);
                        }
                        for (String name : names) {
                            nameMap.put(name, function);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.notfind.class1", type), e);
                    }
                }
            }
        }
    }

    @Override
    public void removeScriptFunction(ScriptFunction function) throws ScriptException {
        function.setScriptEngine(null);
        if (function instanceof DynamicNameScriptFunction) {
            if (function.getBindingTypes() == null) {
                this.dynamicList.remove(function);
            } else {
                String[] types;
                for (String type : types = function.getBindingTypes().split(",")) {
                    try {
                        Class<?> clazz = Class.forName(type);
                        List<DynamicNameScriptFunction> dynamicNameList = this.typeDynamicMap.get(clazz);
                        if (dynamicNameList == null) continue;
                        dynamicNameList.remove(function);
                        if (!dynamicNameList.isEmpty()) continue;
                        this.typeDynamicMap.remove(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.notfind.class2", type), e);
                    }
                }
            }
        } else {
            String[] names = function.getNames().split(",");
            if (function.getBindingTypes() == null) {
                for (String name : names) {
                    this.functionMap.remove(name);
                }
            } else {
                String[] types;
                for (String type : types = function.getBindingTypes().split(",")) {
                    try {
                        Class<?> clazz = Class.forName(type);
                        Map<String, ScriptFunction> nameMap = this.typeFunctionMap.get(clazz);
                        if (nameMap == null) continue;
                        for (String name : names) {
                            nameMap.remove(name);
                        }
                        if (!nameMap.isEmpty()) continue;
                        this.typeFunctionMap.remove(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.notfind.class2", type), e);
                    }
                }
            }
        }
    }

    @Override
    public ScriptFunction findScriptFunction(Object object, String functionName) throws ScriptException {
        if (object == null) {
            ScriptFunction function = this.functionMap.get(functionName);
            if (function == null) {
                for (DynamicNameScriptFunction dynamicNameScriptFunction : this.dynamicList) {
                    if (!dynamicNameScriptFunction.exsitFunctionName(functionName)) continue;
                    return dynamicNameScriptFunction;
                }
            }
            return function;
        }
        ScriptFunction function = this.findScriptFunctionByClass(object.getClass(), functionName);
        if (function != null) {
            return function;
        }
        for (Class<?> clazz : this.typeFunctionMap.keySet()) {
            if (!clazz.isInstance(object) || (function = this.findScriptFunctionByClass(clazz, functionName)) == null) continue;
            return function;
        }
        function = this.findDynamicNameScriptFunction(object.getClass(), functionName);
        if (function != null) {
            return function;
        }
        for (Class<?> clazz : this.typeDynamicMap.keySet()) {
            if (!clazz.isInstance(object) || (function = this.findDynamicNameScriptFunction(clazz, functionName)) == null) continue;
            return function;
        }
        return null;
    }

    @Override
    public List<FunctionConfig> getFunctionConfigs(Object object) throws ScriptException {
        ArrayList<FunctionConfig> configs = new ArrayList<FunctionConfig>();
        if (object == null) {
            for (ScriptFunction function : this.functionMap.values()) {
                configs.addAll(function.getFunctionConfigs());
            }
            for (DynamicNameScriptFunction dynamicNameScriptFunction : this.dynamicList) {
                configs.addAll(dynamicNameScriptFunction.getFunctionConfigs());
            }
        } else {
            for (Class<?> clazz : this.typeFunctionMap.keySet()) {
                if (!clazz.equals(object.getClass()) && !clazz.isInstance(object)) continue;
                Map<String, ScriptFunction> nameMap = this.typeFunctionMap.get(clazz);
                for (ScriptFunction function : nameMap.values()) {
                    configs.addAll(function.getFunctionConfigs());
                }
            }
            for (Class<?> clazz : this.typeDynamicMap.keySet()) {
                if (!clazz.equals(object.getClass()) && !clazz.isInstance(object)) continue;
                List<DynamicNameScriptFunction> dynamicNameScriptFunctions = this.typeDynamicMap.get(clazz);
                for (DynamicNameScriptFunction dynamicNameScriptFunction : dynamicNameScriptFunctions) {
                    configs.addAll(dynamicNameScriptFunction.getFunctionConfigs());
                }
            }
        }
        Collections.sort(configs);
        return configs;
    }

    private ScriptFunction findDynamicNameScriptFunction(Class<?> clazz, String functionName) {
        List<DynamicNameScriptFunction> dynamicNameList = this.typeDynamicMap.get(clazz);
        if (dynamicNameList != null) {
            for (DynamicNameScriptFunction dynamicNameScriptFunction : dynamicNameList) {
                if (!dynamicNameScriptFunction.exsitFunctionName(functionName)) continue;
                return dynamicNameScriptFunction;
            }
        }
        return null;
    }

    private ScriptFunction findScriptFunctionByClass(Class<?> clazz, String functionName) {
        Map<String, ScriptFunction> nameMap = this.typeFunctionMap.get(clazz);
        return nameMap != null ? nameMap.get(functionName) : null;
    }

    @Override
    protected ScriptSegment findScriptSegmentWithoutCache(Object queryRule) throws ScriptException {
        ScriptSegment segment = null;
        String sourceName = "S" + System.nanoTime();
        try {
            segment = this.getScriptInterpret().createScriptSegment(this, sourceName, (String)queryRule);
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.parser.error", queryRule, e.getMessage()));
        }
        return segment;
    }

    @Override
    public void start() throws ScriptException {
        LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("engine.start.finish"));
    }

    @Override
    public void stop() throws ScriptException {
        super.stop();
        this.functionMap.clear();
        this.typeFunctionMap.clear();
        this.dynamicList.clear();
        this.typeDynamicMap.clear();
        LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("engine.stop.finish"));
    }
}

