/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.AttributeProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.attribute.ArrayLengthProcessor;
import org.tinygroup.tinyscript.interpret.attribute.FieldAttributeProcessor;
import org.tinygroup.tinyscript.interpret.attribute.MapAttributeProcessor;
import org.tinygroup.tinyscript.interpret.attribute.MethodAttributeProcessor;
import org.tinygroup.tinyscript.interpret.attribute.ScriptClassInstanceAttributeProcessor;
import org.tinygroup.tinyscript.interpret.attribute.ScriptCollectionModelAttributeProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public final class AttributeUtil {
    private static List<AttributeProcessor> attributeProcessors = new ArrayList<AttributeProcessor>();

    private AttributeUtil() {
    }

    public static void addAttributeProcessor(AttributeProcessor processor) {
        for (AttributeProcessor oldAttributeProcessor : attributeProcessors) {
            if (!oldAttributeProcessor.equals(processor) && !oldAttributeProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        attributeProcessors.add(processor);
    }

    public static void addAttributeProcessor(AttributeProcessor processor, int index) {
        for (AttributeProcessor oldAttributeProcessor : attributeProcessors) {
            if (!oldAttributeProcessor.equals(processor) && !oldAttributeProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        attributeProcessors.add(index, processor);
    }

    public static void removeAttributeProcessor(AttributeProcessor processor) {
        attributeProcessors.remove(processor);
    }

    public static Object getAttribute(Object object, Object name) throws Exception {
        if (object == null) {
            return null;
        }
        for (AttributeProcessor processor : attributeProcessors) {
            try {
                if (!processor.isMatch(object, name)) continue;
                return processor.getAttribute(object, name);
            }
            catch (NotMatchException e) {
            }
            catch (Exception e) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("attribute.run.error", object.getClass().getName(), name), e);
            }
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("attribute.notfound.error", object.getClass().getName(), name));
    }

    static {
        AttributeUtil.addAttributeProcessor(new MapAttributeProcessor());
        AttributeUtil.addAttributeProcessor(new ArrayLengthProcessor());
        AttributeUtil.addAttributeProcessor(new ScriptCollectionModelAttributeProcessor());
        AttributeUtil.addAttributeProcessor(new ScriptClassInstanceAttributeProcessor());
        AttributeUtil.addAttributeProcessor(new MethodAttributeProcessor());
        AttributeUtil.addAttributeProcessor(new FieldAttributeProcessor());
    }
}

