/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.impl.ScriptMethodContext;
import org.tinygroup.tinyscript.interpret.InstanceOfProcessor;
import org.tinygroup.tinyscript.interpret.NewInstanceProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.anonymous.ComparatorProcessor;
import org.tinygroup.tinyscript.interpret.anonymous.RunnableProcessor;
import org.tinygroup.tinyscript.interpret.anonymous.SingleMethodProcessor;
import org.tinygroup.tinyscript.interpret.directive.JavaInstanceOfProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;
import org.tinygroup.tinyscript.interpret.newinstance.JavaInstanceProcessor;
import org.tinygroup.tinyscript.interpret.newinstance.ScriptClassInstanceProcessor;

public class ClassInstanceUtil {
    private static final List<SingleMethodProcessor> singleMethodProcessors = new ArrayList<SingleMethodProcessor>();
    private static final List<NewInstanceProcessor> newInstanceProcessors = new ArrayList<NewInstanceProcessor>();
    private static final List<InstanceOfProcessor> instanceOfProcessors = new ArrayList<InstanceOfProcessor>();

    public static void addSingleMethodProxy(SingleMethodProcessor singleMethodProxy) {
        for (SingleMethodProcessor oldSingleMethodProcessor : singleMethodProcessors) {
            if (!oldSingleMethodProcessor.equals(singleMethodProxy) && !oldSingleMethodProcessor.getClass().isInstance(singleMethodProxy)) continue;
            return;
        }
        singleMethodProcessors.add(singleMethodProxy);
    }

    public static void removeSingleMethodProxy(SingleMethodProcessor singleMethodProxy) {
        singleMethodProcessors.remove(singleMethodProxy);
    }

    public static void addNewInstanceProcessor(NewInstanceProcessor processor) {
        for (NewInstanceProcessor newInstanceProcessor : newInstanceProcessors) {
            if (!newInstanceProcessor.equals(processor) && !newInstanceProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        newInstanceProcessors.add(processor);
    }

    public static void removeNewInstanceProcessor(NewInstanceProcessor processor) {
        newInstanceProcessors.remove(processor);
    }

    public static void addInstanceOfProcessor(InstanceOfProcessor processor) {
        for (InstanceOfProcessor instanceOfProcessor : instanceOfProcessors) {
            if (!instanceOfProcessor.equals(processor) && !instanceOfProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        instanceOfProcessors.add(processor);
    }

    public static void removeInstanceOfProcessor(InstanceOfProcessor processor) {
        instanceOfProcessors.remove(processor);
    }

    public static SingleMethodProcessor findSingleMethodProcessor(Class<?> parameterType) {
        for (SingleMethodProcessor singleMethodProcessor : singleMethodProcessors) {
            if (!parameterType.equals(singleMethodProcessor.getType())) continue;
            return singleMethodProcessor;
        }
        return null;
    }

    public static Object newInstance(ScriptSegment segment, ScriptContext context, String className, List<Object> paramList) throws Exception {
        ScriptClassInstance classInstance = null;
        if (context instanceof ScriptMethodContext) {
            classInstance = ((ScriptMethodContext)context).getScriptClassInstance();
        }
        List<String> importList = null;
        if (classInstance != null) {
            importList = classInstance.getScriptClass().getScriptSegment().getImportList();
        }
        for (NewInstanceProcessor processor : newInstanceProcessors) {
            Object clazz = processor.findClass(segment, className, importList);
            try {
                if (clazz == null) continue;
                return processor.newInstance(clazz, context, paramList);
            }
            catch (NotMatchException e) {
            }
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("newinstance.notfound.error", className));
    }

    public static boolean isInstance(Object object, Object type) throws Exception {
        for (InstanceOfProcessor processor : instanceOfProcessors) {
            try {
                if (!processor.isMatch(object, type)) continue;
                return processor.isInstance(object, type);
            }
            catch (NotMatchException e) {
            }
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("unmatch.info1", InstanceOfProcessor.class.getName()));
    }

    static {
        ClassInstanceUtil.addSingleMethodProxy(new RunnableProcessor());
        ClassInstanceUtil.addSingleMethodProxy(new ComparatorProcessor());
        ClassInstanceUtil.addNewInstanceProcessor(new JavaInstanceProcessor());
        ClassInstanceUtil.addNewInstanceProcessor(new ScriptClassInstanceProcessor());
        ClassInstanceUtil.addInstanceOfProcessor(new JavaInstanceOfProcessor());
    }
}

