/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.io.File;
import java.io.IOException;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFS;
import org.tinygroup.vfs.impl.FileObjectImpl;
import org.tinygroup.vfs.impl.FileSchemaProvider;

public final class FileObjectUtil {
    private FileObjectUtil() {
    }

    public static FileObject findFileObject(String path, boolean findInJar) throws Exception {
        FileObject fileObject = VFS.resolveFile((String)path);
        if (fileObject != null && fileObject.isExist()) {
            return fileObject;
        }
        FileResolver fileResolver = (FileResolver)BeanContainerFactory.getBeanContainer((ClassLoader)FileObjectUtil.class.getClassLoader()).getBean("fileResolver");
        if (fileResolver != null) {
            for (String sPath : fileResolver.getScanningPaths()) {
                FileObject result;
                FileObject dir = VFS.resolveFile((String)sPath);
                if (dir.isInPackage() && !findInJar || (result = FileObjectUtil.findFileObject(dir, path)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static FileObject getOrCreateFile(String fileUrl, boolean findInJar) throws ScriptException, IOException {
        String parentFile = fileUrl.substring(0, fileUrl.lastIndexOf("/"));
        String fileName = fileUrl.substring(fileUrl.lastIndexOf("/") + 1);
        FileObject fileObject = VFS.resolveFile((String)parentFile);
        if (fileObject != null && fileObject.isExist()) {
            return FileObjectUtil.getOrCreateChildFile(fileObject, fileName);
        }
        FileResolver fileResolver = (FileResolver)BeanContainerFactory.getBeanContainer((ClassLoader)FileObjectUtil.class.getClassLoader()).getBean("fileResolver");
        if (fileResolver != null) {
            for (String sPath : fileResolver.getScanningPaths()) {
                FileObject result;
                FileObject dir = VFS.resolveFile((String)sPath);
                if (dir.isInPackage() && !findInJar || (result = FileObjectUtil.getOrCreateChildFile(FileObjectUtil.findFileObject(dir, parentFile), fileName)) == null || !result.isExist()) continue;
                return result;
            }
        }
        return null;
    }

    private static FileObject findFileObject(FileObject fileObject, String path) {
        if (fileObject.getPath().equals(path)) {
            return fileObject;
        }
        if (fileObject.getChildren() != null) {
            for (FileObject child : fileObject.getChildren()) {
                FileObject result = FileObjectUtil.findFileObject(child, path);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static FileObject getOrCreateChildFile(FileObject parent, String fileName) throws IOException {
        if (parent == null) {
            return null;
        }
        if (parent.getChild(fileName) == null) {
            File file = new File(parent.getAbsolutePath() + File.separator + fileName);
            if (file.createNewFile()) {
                return new FileObjectImpl((SchemaProvider)new FileSchemaProvider(), file);
            }
        } else {
            return parent.getChild(fileName);
        }
        return null;
    }
}

