/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.FunctionCallProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.call.CollectionModelProcessor;
import org.tinygroup.tinyscript.interpret.call.JavaMethodProcessor;
import org.tinygroup.tinyscript.interpret.call.JavaStaticMethodProcessor;
import org.tinygroup.tinyscript.interpret.call.LambdaFunctionProcessor;
import org.tinygroup.tinyscript.interpret.call.ScriptClassInstanceProcessor;
import org.tinygroup.tinyscript.interpret.call.ScriptFunctionProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class FunctionCallUtil {
    private static List<FunctionCallProcessor> processors = new ArrayList<FunctionCallProcessor>();

    public static void addFunctionCallProcessor(FunctionCallProcessor processor) {
        for (FunctionCallProcessor functionCallProcessor : processors) {
            if (!functionCallProcessor.equals(processor) && !functionCallProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        processors.add(processor);
    }

    public static void removeFunctionCallProcessor(FunctionCallProcessor processor) {
        processors.remove(processor);
    }

    public static Object operate(ScriptSegment segment, ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        for (FunctionCallProcessor processor : processors) {
            try {
                return processor.invoke(segment, context, object, methodName, parameters);
            }
            catch (NotMatchException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        if (object != null) {
            throw new NoSuchMethodException(ResourceBundleUtil.getDefaultMessage("call.notfound.error", object.getClass().getName(), methodName));
        }
        throw new NoSuchMethodException(ResourceBundleUtil.getDefaultMessage("call.null.error", methodName));
    }

    static {
        FunctionCallUtil.addFunctionCallProcessor(new ScriptFunctionProcessor());
        FunctionCallUtil.addFunctionCallProcessor(new ScriptClassInstanceProcessor());
        FunctionCallUtil.addFunctionCallProcessor(new JavaMethodProcessor());
        FunctionCallUtil.addFunctionCallProcessor(new JavaStaticMethodProcessor());
        FunctionCallUtil.addFunctionCallProcessor(new LambdaFunctionProcessor());
        FunctionCallUtil.addFunctionCallProcessor(new CollectionModelProcessor());
    }
}

