/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.util.CollectionUtils;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.tinyscript.ScriptClass;
import org.tinygroup.tinyscript.ScriptClassConstructor;
import org.tinygroup.tinyscript.ScriptClassField;
import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptClassMethod;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.impl.AbstractScriptEngine;
import org.tinygroup.tinyscript.impl.DefaultScriptContext;
import org.tinygroup.tinyscript.interpret.InnerScriptReader;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.exception.InterpretFormatException;
import org.tinygroup.tinyscript.interpret.exception.ReturnException;
import org.tinygroup.tinyscript.interpret.exception.RunScriptException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class ParserRuleContextSegment
implements ScriptSegment {
    private String segmentId;
    private String script;
    private TinyScriptParser.CompilationUnitContext parserRuleContext;
    private ScriptEngine scriptEngine;
    private String packageName;
    private InnerScriptClass scriptClass;
    private List<String> importList;
    private InnerScriptReader scriptReader;
    private Map<Object, Object> cache;

    public ParserRuleContextSegment(ScriptEngine engine, String sourceName, String scriptText, TinyScriptParser.CompilationUnitContext compilationUnitContext) throws ScriptException {
        this.scriptEngine = engine;
        this.segmentId = sourceName;
        this.script = scriptText;
        this.parserRuleContext = compilationUnitContext;
        this.cache = new HashMap<Object, Object>();
        this.initContext();
    }

    @Override
    public String getSegmentId() {
        return this.segmentId == null ? this.getName() : this.segmentId;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public String getScript(int startLine, int startCharPositionInLine, int stopLine, int stopCharPositionInLine) throws ScriptException {
        if (this.scriptReader == null) {
            this.scriptReader = new InnerScriptReader(this.script);
        }
        return this.scriptReader.getScript(startLine, startCharPositionInLine, stopLine, stopCharPositionInLine);
    }

    @Override
    public String getScriptFromStart(int line, int charPositionInLine) throws ScriptException {
        if (this.scriptReader == null) {
            this.scriptReader = new InnerScriptReader(this.script);
        }
        return this.scriptReader.getScriptFromStart(line, charPositionInLine);
    }

    @Override
    public String getScriptToStop(int line, int charPositionInLine) throws ScriptException {
        if (this.scriptReader == null) {
            this.scriptReader = new InnerScriptReader(this.script);
        }
        return this.scriptReader.getScriptToStop(line, charPositionInLine);
    }

    public String getName() {
        if (StringUtil.isEmpty((String)this.packageName)) {
            return this.scriptClass == null ? null : this.scriptClass.getClassName();
        }
        return this.scriptClass == null ? this.packageName : this.packageName + "." + this.scriptClass.getClassName();
    }

    private void initContext() throws ScriptException {
        DefaultScriptContext context = new DefaultScriptContext();
        if (this.parserRuleContext.packageDeclaration() != null) {
            this.packageName = (String)this.execute((ParseTree)this.parserRuleContext.packageDeclaration(), context);
        }
        if (!CollectionUtils.isEmpty(this.parserRuleContext.importDeclaration())) {
            this.importList = new ArrayList<String>();
            for (TinyScriptParser.ImportDeclarationContext importDeclarationContext : this.parserRuleContext.importDeclaration()) {
                this.importList.add((String)this.execute((ParseTree)importDeclarationContext, context));
            }
        }
        if (this.parserRuleContext.classDeclaration() != null) {
            this.scriptClass = new InnerScriptClass(this.parserRuleContext.classDeclaration());
        }
    }

    @Override
    public Object execute(ScriptContext context) throws ScriptException {
        return this.execute((ParseTree)this.parserRuleContext, context);
    }

    @Override
    public Map<Object, Object> getCache() {
        return this.cache;
    }

    private Object execute(ParseTree tree, ScriptContext context) throws ScriptException {
        if (!(this.scriptEngine instanceof AbstractScriptEngine)) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("script.parser.error1", this.scriptEngine.getClass().getName()));
        }
        AbstractScriptEngine abstractScriptEngine = (AbstractScriptEngine)this.scriptEngine;
        try {
            LambdaFunction f;
            ScriptResult result = abstractScriptEngine.getScriptInterpret().interpretParseTree(tree, this, context);
            if (result.isVoid()) {
                return null;
            }
            if (result.getResult() != null && result.getResult() instanceof LambdaFunction && (f = (LambdaFunction)result.getResult()).getFunctionName() == null) {
                return f.execute(context, new Object[0]).getResult();
            }
            return result.getResult();
        }
        catch (ReturnException e) {
            return e.getValue();
        }
        catch (RunScriptException e) {
            throw new InterpretFormatException(e);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("script.parser.error2", this.segmentId, this.script), e);
        }
    }

    @Override
    public void setScriptEngine(ScriptEngine engine) {
        this.scriptEngine = engine;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public List<String> getImportList() {
        return this.importList;
    }

    @Override
    public ScriptClass getScriptClass() {
        return this.scriptClass;
    }

    class InnerScriptField
    implements ScriptClassField {
        private String fieldName;
        private Object value;
        private TinyScriptParser.VariableDeclaratorContext variableDeclaratorContext;

        public InnerScriptField(TinyScriptParser.VariableDeclaratorContext context) throws ScriptException {
            this.variableDeclaratorContext = context;
            this.initContext();
        }

        private void initContext() throws ScriptException {
            this.fieldName = this.variableDeclaratorContext.getChild(0).getText();
            this.value = ParserRuleContextSegment.this.execute((ParseTree)this.variableDeclaratorContext, new DefaultScriptContext());
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    class InnerScriptMethod
    implements ScriptClassMethod {
        private TinyScriptParser.MethodDeclarationContext methodDeclarationContext;
        private String methodName;
        private String[] parameterNames;

        public InnerScriptMethod(TinyScriptParser.MethodDeclarationContext context) throws ScriptException {
            this.methodDeclarationContext = context;
            this.initContext();
        }

        private void initContext() throws ScriptException {
            this.methodName = this.methodDeclarationContext.Identifier().getText();
            if (this.methodDeclarationContext.formalParameters().formalParameterList() != null) {
                List<TinyScriptParser.FormalParameterContext> formalParameterContextList = this.methodDeclarationContext.formalParameters().formalParameterList().formalParameter();
                this.parameterNames = new String[formalParameterContextList.size()];
                for (int i = 0; i < formalParameterContextList.size(); ++i) {
                    this.parameterNames[i] = formalParameterContextList.get(i).getText();
                }
            }
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public String[] getParamterNames() {
            return this.parameterNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(ScriptContext context, Object ... parameters) throws ScriptException {
            try {
                if (this.parameterNames != null && this.parameterNames.length != 0 || parameters != null && parameters.length != 0) {
                    if (this.parameterNames != null && parameters != null && this.parameterNames.length == parameters.length) {
                        for (int i = 0; i < this.parameterNames.length; ++i) {
                            context.put(this.parameterNames[i], parameters[i]);
                        }
                    } else {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("script.parser.error5"));
                    }
                }
                Object object = ParserRuleContextSegment.this.execute((ParseTree)this.methodDeclarationContext, context);
                return object;
            }
            finally {
                if (this.parameterNames != null) {
                    for (int i = 0; i < this.parameterNames.length; ++i) {
                        context.remove(this.parameterNames[i]);
                    }
                }
            }
        }
    }

    class InnerScriptClassConstructor
    implements ScriptClassConstructor {
        private TinyScriptParser.MethodDeclarationContext methodDeclarationContext;
        private String[] parameterNames;
        private InnerScriptClass scriptClass;

        public InnerScriptClassConstructor(TinyScriptParser.MethodDeclarationContext methodDeclarationContext, InnerScriptClass scriptClass) throws ScriptException {
            this.methodDeclarationContext = methodDeclarationContext;
            this.scriptClass = scriptClass;
            this.initContext();
        }

        private void initContext() throws ScriptException {
            if (this.methodDeclarationContext.formalParameters().formalParameterList() != null) {
                List<TinyScriptParser.FormalParameterContext> formalParameterContextList = this.methodDeclarationContext.formalParameters().formalParameterList().formalParameter();
                this.parameterNames = new String[formalParameterContextList.size()];
                for (int i = 0; i < formalParameterContextList.size(); ++i) {
                    this.parameterNames[i] = formalParameterContextList.get(i).getText();
                }
            }
        }

        @Override
        public String[] getParamterNames() {
            return this.parameterNames;
        }

        @Override
        public boolean isMatch(Object ... parameters) {
            int m = this.parameterNames == null ? 0 : this.parameterNames.length;
            int n = parameters == null ? 0 : parameters.length;
            return m == n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScriptClassInstance newInstance(ScriptContext context, Object ... parameters) throws ScriptException {
            int i;
            InnerScriptClassInstance instance = new InnerScriptClassInstance(this.scriptClass);
            try {
                if (this.parameterNames != null) {
                    for (i = 0; i < this.parameterNames.length; ++i) {
                        context.getItemMap().put(this.parameterNames[i], parameters[i]);
                        if (!instance.existField(this.parameterNames[i])) continue;
                        instance.setField(this.parameterNames[i], parameters[i]);
                    }
                }
                ScriptContextUtil.setScriptClassInstance(context, instance);
                ParserRuleContextSegment.this.execute((ParseTree)this.methodDeclarationContext.methodBody(), context);
            }
            finally {
                if (this.parameterNames != null) {
                    for (i = 0; i < this.parameterNames.length; ++i) {
                        context.getItemMap().remove(this.parameterNames[i]);
                    }
                }
                ScriptContextUtil.setScriptClassInstance(context, null);
            }
            return instance;
        }
    }

    class InnerScriptContext
    extends ContextImpl
    implements ScriptContext {
        private ScriptContext scriptContext;
        private ScriptClassInstance instance;

        public InnerScriptContext(ScriptContext context) {
            this.scriptContext = context instanceof InnerScriptContext ? ((InnerScriptContext)context).getScriptContext() : context;
        }

        public ScriptContext getScriptContext() {
            return this.scriptContext;
        }

        public boolean exist(String name) {
            boolean exist = this.instance.existField(name);
            if (exist) {
                return true;
            }
            return this.scriptContext.exist(name);
        }

        public <T> T get(String name) {
            if (this.instance.existField(name)) {
                return (T)this.instance.getField(name);
            }
            return (T)this.scriptContext.get(name);
        }
    }

    class InnerScriptClassInstance
    implements ScriptClassInstance {
        private InnerScriptClass innerScriptClass;
        private Map<String, Object> valueMaps = new HashMap<String, Object>();
        private InnerScriptContext scriptContext;

        public InnerScriptClassInstance(InnerScriptClass clazz) {
            this.innerScriptClass = clazz;
            for (ScriptClassField field : this.innerScriptClass.fieldMaps.values()) {
                this.valueMaps.put(field.getFieldName(), field.getValue());
            }
        }

        @Override
        public ScriptClass getScriptClass() {
            return this.innerScriptClass;
        }

        @Override
        public Object getField(String fieldName) {
            return this.valueMaps.get(fieldName);
        }

        @Override
        public boolean existField(String fieldName) {
            return this.valueMaps.containsKey(fieldName);
        }

        @Override
        public void setField(String fieldName, Object value) {
            this.valueMaps.put(fieldName, value);
        }

        @Override
        public void setScriptContext(ScriptContext context) {
            this.scriptContext = new InnerScriptContext(context);
            this.scriptContext.instance = this;
        }

        @Override
        public Object execute(ScriptContext context, String methodName, Object ... parameters) throws ScriptException {
            ScriptClassMethod method = this.innerScriptClass.getScriptMethod(methodName);
            if (method == null) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("script.parser.error4", this.innerScriptClass.getClassName(), methodName));
            }
            return method.execute(context, parameters);
        }

        public String toString() {
            ScriptClassMethod method = this.innerScriptClass.getScriptMethod("toString");
            if (method != null && (method.getParamterNames() == null || method.getParamterNames().length == 0)) {
                try {
                    return (String)method.execute(this.scriptContext, new Object[0]);
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.innerScriptClass.getClassName()).append("[");
            ScriptClassField[] fields = this.innerScriptClass.getScriptFields();
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    ScriptClassField field = fields[i];
                    sb.append(field.getFieldName()).append("=").append(this.valueMaps.get(field.getFieldName()));
                    if (i >= fields.length - 1) continue;
                    sb.append(",");
                }
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            ScriptClassMethod method = this.innerScriptClass.getScriptMethod("hashCode");
            if (method != null && (method.getParamterNames() == null || method.getParamterNames().length == 0)) {
                try {
                    return (Integer)method.execute(this.scriptContext, new Object[0]);
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            ScriptClassMethod method = this.innerScriptClass.getScriptMethod("equals");
            if (method != null && method.getParamterNames() != null && method.getParamterNames().length == 1) {
                try {
                    return (Boolean)method.execute(this.scriptContext, obj);
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.equals(obj);
        }
    }

    class InnerScriptClass
    implements ScriptClass {
        private TinyScriptParser.ClassDeclarationContext classDeclarationContext;
        private String className;
        private Map<String, ScriptClassMethod> methodMaps = new HashMap<String, ScriptClassMethod>();
        private Map<String, ScriptClassField> fieldMaps = new HashMap<String, ScriptClassField>();
        private ScriptClassConstructor[] constructors = null;

        public InnerScriptClass(TinyScriptParser.ClassDeclarationContext context) throws ScriptException {
            this.classDeclarationContext = context;
            this.initContext();
        }

        private void initContext() throws ScriptException {
            this.className = (String)ParserRuleContextSegment.this.execute((ParseTree)this.classDeclarationContext, new DefaultScriptContext());
            List<TinyScriptParser.MemberDeclarationContext> members = this.classDeclarationContext.classBody().memberDeclaration();
            if (!CollectionUtils.isEmpty(members)) {
                ArrayList<InnerScriptClassConstructor> constructorList = new ArrayList<InnerScriptClassConstructor>();
                for (TinyScriptParser.MemberDeclarationContext memberDeclarationContext : members) {
                    if (memberDeclarationContext.methodDeclaration() != null) {
                        if (memberDeclarationContext.methodDeclaration().Identifier().getText().equals(this.className)) {
                            InnerScriptClassConstructor constructor = new InnerScriptClassConstructor(memberDeclarationContext.methodDeclaration(), this);
                            constructorList.add(constructor);
                        } else {
                            InnerScriptMethod method = new InnerScriptMethod(memberDeclarationContext.methodDeclaration());
                            this.methodMaps.put(method.getMethodName(), method);
                        }
                    }
                    if (memberDeclarationContext.fieldDeclaration() == null) continue;
                    try {
                        for (TinyScriptParser.VariableDeclaratorContext variableDeclaratorContext : memberDeclarationContext.fieldDeclaration().variableDeclarators().variableDeclarator()) {
                            InnerScriptField field = new InnerScriptField(variableDeclaratorContext);
                            this.fieldMaps.put(field.getFieldName(), field);
                        }
                    }
                    catch (Exception e) {
                        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("script.parser.error3", this.className), e);
                    }
                }
                this.constructors = new ScriptClassConstructor[constructorList.size()];
                constructorList.toArray(this.constructors);
            }
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public ScriptClassMethod getScriptMethod(String methodName) {
            return this.methodMaps.get(methodName);
        }

        @Override
        public ScriptClassField getScriptField(String fieldName) {
            return this.fieldMaps.get(fieldName);
        }

        @Override
        public ScriptClassInstance newInstance(ScriptContext context, Object ... parameters) throws ScriptException {
            ScriptClassConstructor[] constructors = this.getScriptClassConstructors();
            if (constructors != null) {
                for (ScriptClassConstructor constructor : constructors) {
                    if (!constructor.isMatch(parameters)) continue;
                    ScriptClassInstance instance = constructor.newInstance(context, parameters);
                    instance.setScriptContext(context);
                    return instance;
                }
            }
            InnerScriptClassInstance instance = new InnerScriptClassInstance(this);
            instance.setScriptContext(context);
            return instance;
        }

        @Override
        public ScriptSegment getScriptSegment() {
            return ParserRuleContextSegment.this;
        }

        @Override
        public ScriptClassMethod[] getScriptMethods() {
            ScriptClassMethod[] methods = new ScriptClassMethod[this.methodMaps.size()];
            return this.methodMaps.values().toArray(methods);
        }

        @Override
        public ScriptClassField[] getScriptFields() {
            ScriptClassField[] fields = new ScriptClassField[this.fieldMaps.size()];
            return this.fieldMaps.values().toArray(fields);
        }

        @Override
        public ScriptClassConstructor[] getScriptClassConstructors() {
            return this.constructors;
        }
    }
}

