/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.Locale;
import java.util.ResourceBundle;

public final class ResourceBundleUtil {
    private static final String DEFAULT_RESOURCE_NAME = "base";

    private ResourceBundleUtil() {
    }

    public static ResourceBundle getBundle(String resourceName) {
        try {
            return ResourceBundle.getBundle(resourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ResourceBundle getBundle(String resourceName, Locale locale) {
        try {
            return ResourceBundle.getBundle(resourceName, locale);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ResourceBundle getBundle(String resourceName, Locale locale, ClassLoader loader) {
        try {
            return ResourceBundle.getBundle(resourceName, locale, loader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMessage(ResourceBundle bundle, String key) {
        try {
            if (bundle != null && key != null) {
                return bundle.getString(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static String getMessage(ResourceBundle bundle, String key, Object ... parameters) {
        try {
            String result;
            if (bundle != null && key != null && (result = bundle.getString(key)) != null) {
                return String.format(result, parameters);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public static String getDefaultMessage(String key) {
        return ResourceBundleUtil.getResourceMessage(DEFAULT_RESOURCE_NAME, key);
    }

    public static String getResourceMessage(String resourceName, String key) {
        ResourceBundle bundle = ResourceBundleUtil.getBundle(resourceName);
        return ResourceBundleUtil.getMessage(bundle, key);
    }

    public static String getDefaultMessage(String key, Object ... parameters) {
        return ResourceBundleUtil.getResourceMessage(DEFAULT_RESOURCE_NAME, key, parameters);
    }

    public static String getResourceMessage(String resourceName, String key, Object ... parameters) {
        ResourceBundle bundle = ResourceBundleUtil.getBundle(resourceName);
        return ResourceBundleUtil.getMessage(bundle, key, parameters);
    }
}

