/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class ScriptContextUtil {
    private static final String LAMBDA_PRE = "$lambda";
    private static final String INSTANCE_NAME = "$intance";
    private static final String ENGINE_NAME = "$scriptEngine";
    private static final String DYNAMIC_FUNCTION_NAME = "$dynamicFunctionName";
    private static final String DATASET_ROWID = "$rowId";
    private static final String CURRENT_DATA = "$it";
    private static final String CUSTOM_BEAN_NAME = "customBean";
    private static final String FIND_CLASS_TAG = "$findClassTag";

    public static void setCurData(ScriptContext context, Object value) {
        context.put(CURRENT_DATA.substring(1), value);
    }

    public static void setDataSetRowId(ScriptContext context, int rowId) {
        context.put(DATASET_ROWID.substring(1), rowId);
    }

    public static void setLambdaFunction(ScriptContext context, LambdaFunction function) {
        if (context != null && function != null) {
            if (function.getFunctionName() != null) {
                context.put(LAMBDA_PRE + function.getFunctionName(), function);
            } else {
                context.put(LAMBDA_PRE, function);
            }
        }
    }

    public static LambdaFunction getLambdaFunction(ScriptContext context, String functionName) {
        if (context != null) {
            if (functionName != null) {
                return (LambdaFunction)context.get(LAMBDA_PRE + functionName);
            }
            return (LambdaFunction)context.get(LAMBDA_PRE);
        }
        return null;
    }

    public static ScriptClassInstance getScriptClassInstance(ScriptContext context) {
        if (context != null) {
            return (ScriptClassInstance)context.get(INSTANCE_NAME);
        }
        return null;
    }

    public static void setScriptClassInstance(ScriptContext context, ScriptClassInstance instance) {
        if (context != null) {
            context.put(INSTANCE_NAME, instance);
        }
    }

    public static void enableFindClassTag(ScriptContext context) {
        if (context != null) {
            context.put(FIND_CLASS_TAG, true);
        }
    }

    public static void disableFindClassTag(ScriptContext context) {
        if (context != null) {
            context.remove(FIND_CLASS_TAG);
        }
    }

    public static boolean getFindClassTag(ScriptContext context) {
        Boolean tag;
        if (context != null && (tag = (Boolean)context.get(FIND_CLASS_TAG)) != null) {
            return tag;
        }
        return false;
    }

    public static ScriptEngine getScriptEngine(ScriptContext context) {
        return (ScriptEngine)context.get(ENGINE_NAME);
    }

    public static void setScriptEngine(ScriptContext context, ScriptEngine engine) {
        context.put(ENGINE_NAME, engine);
    }

    public static String getDynamicFunctionName(ScriptContext context) {
        return (String)context.get(DYNAMIC_FUNCTION_NAME);
    }

    public static void addDynamicFunctionName(ScriptContext context, String name) {
        context.put(DYNAMIC_FUNCTION_NAME, name);
    }

    public static void removeDynamicFunctionName(ScriptContext context, String name) {
        String value = (String)context.get(DYNAMIC_FUNCTION_NAME);
        if (name != null && name.equals(value)) {
            context.remove(DYNAMIC_FUNCTION_NAME);
        }
    }

    public static String convertExpression(String expression) {
        if (expression.indexOf("->") > 0) {
            return expression;
        }
        if (!expression.startsWith("return")) {
            expression = "return " + expression;
        }
        if (!expression.endsWith(";")) {
            expression = expression + ";";
        }
        return expression;
    }

    public static Object executeExpression(ScriptContext context, String expression) throws ScriptException {
        String newExpression = ScriptContextUtil.convertExpression(expression);
        ScriptEngine engine = ScriptContextUtil.getScriptEngine(context);
        return engine.execute(newExpression, context);
    }

    public static Object[] executeExpression(ScriptContext context, String ... expressions) throws ScriptException {
        Object[] result = new Object[expressions.length];
        ScriptEngine engine = ScriptContextUtil.getScriptEngine(context);
        for (int i = 0; i < result.length; ++i) {
            result[i] = engine.execute(ScriptContextUtil.convertExpression(expressions[i]), context);
        }
        return result;
    }

    public static String getBeanName(ScriptContext context, String parameterName) throws ScriptException {
        String beanName = (String)context.get(parameterName);
        if (beanName == null) {
            beanName = ConfigurationUtil.getConfigurationManager().getConfiguration(parameterName);
        }
        if (beanName != null) {
            return beanName;
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.notfound.bean", parameterName));
    }

    public static String getCustomBeanName(ScriptContext context) throws ScriptException {
        return ScriptContextUtil.getBeanName(context, CUSTOM_BEAN_NAME);
    }
}

