/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ParserRuleContextSegment;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptParserErrorListener;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.TerminalNodeProcessor;
import org.tinygroup.tinyscript.interpret.exception.ReturnException;
import org.tinygroup.tinyscript.interpret.terminal.DefaultTerminalNodeProcessor;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptLexer;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public final class ScriptInterpret {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScriptInterpret.class);
    private static final int TERMINALNODE_MAX = 200;
    private TerminalNodeProcessor[] terminalNodeProcessors;
    private Map<Class<ParserRuleContext>, ParserRuleContextProcessor> contextProcessorMap;
    private DefaultTerminalNodeProcessor defaultTerminalNodeProcessor;

    public ScriptInterpret() {
        this(200);
    }

    public ScriptInterpret(int limit) {
        int num = limit <= 0 ? 200 : limit;
        this.terminalNodeProcessors = new TerminalNodeProcessor[num];
        this.contextProcessorMap = new HashMap<Class<ParserRuleContext>, ParserRuleContextProcessor>();
        this.defaultTerminalNodeProcessor = new DefaultTerminalNodeProcessor();
    }

    public void addTerminalNodeProcessor(TerminalNodeProcessor processor) {
        this.terminalNodeProcessors[processor.getType()] = processor;
    }

    public void addContextProcessor(ParserRuleContextProcessor contextProcessor) {
        this.contextProcessorMap.put(contextProcessor.getType(), contextProcessor);
    }

    public ScriptSegment createScriptSegment(ScriptEngine engine, String sourceName, String script) throws Exception {
        TinyScriptParser.CompilationUnitContext context = this.parserScriptSegmentContext(sourceName, script);
        ParserRuleContextSegment scriptSegment = new ParserRuleContextSegment(engine, sourceName, script, context);
        return scriptSegment;
    }

    public TinyScriptParser.CompilationUnitContext parserScriptSegmentContext(String sourceName, String script) throws ScriptException {
        ANTLRInputStream is = new ANTLRInputStream(script);
        is.name = sourceName;
        TinyScriptLexer lexer = new TinyScriptLexer((CharStream)is);
        TinyScriptParser parser = new TinyScriptParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ScriptParserErrorListener listener = new ScriptParserErrorListener(sourceName);
        lexer.removeErrorListeners();
        lexer.addErrorListener(listener);
        parser.removeErrorListeners();
        parser.addErrorListener(listener);
        TinyScriptParser.CompilationUnitContext context = parser.compilationUnit();
        if (!listener.getExceptionList().isEmpty()) {
            throw listener.getExceptionList().get(0);
        }
        return context;
    }

    public Object interpretParseTreeValue(ParseTree tree, ScriptSegment segment, ScriptContext context) throws Exception {
        ScriptResult result = this.interpretParseTree(tree, segment, context);
        if (result != null && !result.isVoid()) {
            return result.getResult();
        }
        return null;
    }

    public ScriptResult interpretParseTree(ParseTree tree, ScriptSegment segment, ScriptContext context) throws Exception {
        ScriptResult returnValue = ScriptResult.VOID_RESULT;
        if (tree == null) {
            return returnValue;
        }
        if (tree instanceof TerminalNode) {
            TerminalNode terminalNode = (TerminalNode)tree;
            TerminalNodeProcessor processor = this.terminalNodeProcessors[terminalNode.getSymbol().getType()];
            if (processor != null) {
                return processor.process(tree, segment, context);
            }
            return this.defaultTerminalNodeProcessor.process(terminalNode, segment, context);
        }
        if (tree instanceof ParserRuleContext) {
            try {
                ParserRuleContextProcessor processor = this.contextProcessorMap.get(tree.getClass());
                if (processor != null && (returnValue = processor.process((ParserRuleContext)tree, this, segment, context)) != null && !returnValue.isContinue()) {
                    return returnValue;
                }
                for (int i = 0; i < tree.getChildCount(); ++i) {
                    ScriptResult value = this.interpretParseTree(tree.getChild(i), segment, context);
                    if (value.getResult() == null) continue;
                    returnValue = value;
                }
                return returnValue;
            }
            catch (ScriptException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("interpret.unknown.error", tree.getClass().getName()));
    }

    public boolean containsReturn(ParserRuleContext tree) throws Exception {
        try {
            this.findReturn(tree);
        }
        catch (ReturnException e) {
            return true;
        }
        return false;
    }

    private void findReturn(TerminalNode terminalNode) throws ReturnException {
        if (terminalNode.getSymbol().getType() == 22) {
            throw new ReturnException((Object)null);
        }
    }

    private void findReturn(ParserRuleContext parserRuleContext) throws ReturnException {
        for (int i = 0; i < parserRuleContext.getChildCount(); ++i) {
            ParseTree parseTree = parserRuleContext.getChild(i);
            if (parseTree instanceof TerminalNode) {
                this.findReturn((TerminalNode)parseTree);
                continue;
            }
            if (!(parseTree instanceof ParserRuleContext)) continue;
            this.findReturn((ParserRuleContext)parseTree);
        }
    }
}

