/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.context.Context;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.context.ArrayCreatorContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ArrayExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ArrayInitializerContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ArrayItemExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ArrayListExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.BlockStatementContextProcessor;
import org.tinygroup.tinyscript.interpret.context.BreakContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ClassDeclarationContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ContinueContextProcessor;
import org.tinygroup.tinyscript.interpret.context.CreatorContextProcessor;
import org.tinygroup.tinyscript.interpret.context.CustomScriptExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.DoContextProcessor;
import org.tinygroup.tinyscript.interpret.context.FieldAccessExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ForContextProcessor;
import org.tinygroup.tinyscript.interpret.context.FunctionCallExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.IfContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ImportDeclarationContextProcessor;
import org.tinygroup.tinyscript.interpret.context.InContextProcessor;
import org.tinygroup.tinyscript.interpret.context.InstanceofContextProcessor;
import org.tinygroup.tinyscript.interpret.context.LambdaExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.MapExpressionContextProcessor;
import org.tinygroup.tinyscript.interpret.context.MathBinaryBasicProcessor;
import org.tinygroup.tinyscript.interpret.context.MathBinaryBitwiseProcessor;
import org.tinygroup.tinyscript.interpret.context.MathBinaryRightProcessor;
import org.tinygroup.tinyscript.interpret.context.MathBinaryShiftProcessor;
import org.tinygroup.tinyscript.interpret.context.MathCompareRelationalProcessor;
import org.tinygroup.tinyscript.interpret.context.MathConditionalTernaryProcessor;
import org.tinygroup.tinyscript.interpret.context.MathLogicalConnectProcessor;
import org.tinygroup.tinyscript.interpret.context.MathSingleLeftProcessor;
import org.tinygroup.tinyscript.interpret.context.MathSingleRightProcessor;
import org.tinygroup.tinyscript.interpret.context.MathUnaryPrefixProcessor;
import org.tinygroup.tinyscript.interpret.context.MethodDeclarationContextProcessor;
import org.tinygroup.tinyscript.interpret.context.NotInContextProcessor;
import org.tinygroup.tinyscript.interpret.context.ObjectCreatorContextProcessor;
import org.tinygroup.tinyscript.interpret.context.PackageDeclarationContextProcessor;
import org.tinygroup.tinyscript.interpret.context.StatementDeclarationContextProcessor;
import org.tinygroup.tinyscript.interpret.context.SwitchContextProcessor;
import org.tinygroup.tinyscript.interpret.context.VariableDeclaratorContextProcessor;
import org.tinygroup.tinyscript.interpret.context.WhileContextProcessor;
import org.tinygroup.tinyscript.interpret.terminal.BlockCommentNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.BooleanNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.CharNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.FloatingPointNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.IdentifierNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.IntegerNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.LBraceNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.LParenNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.LineCommentNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.NullNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.RBraceNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.RParenNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.ReturnNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.SemiNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.StringNodeProcessor;
import org.tinygroup.tinyscript.interpret.terminal.ThisNodeProcessor;

public final class ScriptUtil {
    private static ScriptInterpret defaultInterpret = new ScriptInterpret();
    private static Map<String, Class<?>> simpleClass = new HashMap();

    public static ScriptInterpret getDefault() {
        return defaultInterpret;
    }

    public static Object getVariableValue(Context context, Object key) {
        String name = key.toString();
        if (context.exist(name)) {
            return context.get(name);
        }
        return ScriptUtil.getValueFromBean(name);
    }

    public static Object getValueFromBean(String name) {
        try {
            return BeanContainerFactory.getBeanContainer((ClassLoader)BeanContainerFactory.class.getClassLoader()).getBean(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> findJavaClass(String className) {
        try {
            if (simpleClass.containsKey(className)) {
                return simpleClass.get(className);
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> findJavaClass(String className, List<String> importList) {
        String newClassName = null;
        Class<?> c = null;
        if (!CollectionUtils.isEmpty(importList)) {
            for (String importPath : importList) {
                if (importPath.endsWith("*")) {
                    newClassName = importPath.substring(0, importPath.length() - 1) + className;
                } else {
                    if (!importPath.endsWith("." + className)) continue;
                    newClassName = importPath;
                }
                if ((c = ScriptUtil.findJavaClass(newClassName)) == null) continue;
                return c;
            }
        }
        return null;
    }

    public static Class<?> findJavaClass(String className, ScriptSegment classSegment, List<String> importList) {
        if (classSegment != null && classSegment.getScriptEngine().isEnableCache()) {
            int hashcode = importList == null ? 0 : importList.hashCode();
            String key = className + "|" + hashcode;
            if (classSegment.getCache().containsKey(key)) {
                return (Class)classSegment.getCache().get(key);
            }
            Class<?> clazz = ScriptUtil.findJavaClassWithoutCache(className, classSegment, importList);
            classSegment.getCache().put(key, clazz);
            return clazz;
        }
        return ScriptUtil.findJavaClassWithoutCache(className, classSegment, importList);
    }

    private static Class<?> findJavaClassWithoutCache(String className, ScriptSegment classSegment, List<String> importList) {
        Class<?> c = null;
        c = ScriptUtil.findJavaClass(className);
        if (c != null) {
            return c;
        }
        c = ScriptUtil.findJavaClass(className, importList);
        if (c != null) {
            return c;
        }
        if (classSegment != null && (c = ScriptUtil.findJavaClass(className, classSegment.getImportList())) != null) {
            return c;
        }
        String newName = "java.lang." + className;
        c = ScriptUtil.findJavaClass(newName);
        if (c != null) {
            return c;
        }
        return null;
    }

    static {
        simpleClass.put("boolean", Boolean.TYPE);
        simpleClass.put("byte", Byte.TYPE);
        simpleClass.put("char", Character.TYPE);
        simpleClass.put("short", Short.TYPE);
        simpleClass.put("int", Integer.TYPE);
        simpleClass.put("long", Long.TYPE);
        simpleClass.put("float", Float.TYPE);
        simpleClass.put("double", Double.TYPE);
        defaultInterpret.addTerminalNodeProcessor(new BooleanNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new SemiNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new NullNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new IntegerNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new FloatingPointNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new CharNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new StringNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new ReturnNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new LParenNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new RParenNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new IdentifierNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new LBraceNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new RBraceNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new ThisNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new BlockCommentNodeProcessor());
        defaultInterpret.addTerminalNodeProcessor(new LineCommentNodeProcessor());
        defaultInterpret.addContextProcessor(new PackageDeclarationContextProcessor());
        defaultInterpret.addContextProcessor(new ImportDeclarationContextProcessor());
        defaultInterpret.addContextProcessor(new ClassDeclarationContextProcessor());
        defaultInterpret.addContextProcessor(new MethodDeclarationContextProcessor());
        defaultInterpret.addContextProcessor(new IfContextProcessor());
        defaultInterpret.addContextProcessor(new ForContextProcessor());
        defaultInterpret.addContextProcessor(new WhileContextProcessor());
        defaultInterpret.addContextProcessor(new VariableDeclaratorContextProcessor());
        defaultInterpret.addContextProcessor(new FunctionCallExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new FieldAccessExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new CreatorContextProcessor());
        defaultInterpret.addContextProcessor(new StatementDeclarationContextProcessor());
        defaultInterpret.addContextProcessor(new ContinueContextProcessor());
        defaultInterpret.addContextProcessor(new BreakContextProcessor());
        defaultInterpret.addContextProcessor(new DoContextProcessor());
        defaultInterpret.addContextProcessor(new SwitchContextProcessor());
        defaultInterpret.addContextProcessor(new BlockStatementContextProcessor());
        defaultInterpret.addContextProcessor(new ArrayListExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new MapExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new ArrayItemExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new ArrayCreatorContextProcessor());
        defaultInterpret.addContextProcessor(new ArrayInitializerContextProcessor());
        defaultInterpret.addContextProcessor(new ObjectCreatorContextProcessor());
        defaultInterpret.addContextProcessor(new ArrayExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new MathUnaryPrefixProcessor());
        defaultInterpret.addContextProcessor(new MathSingleRightProcessor());
        defaultInterpret.addContextProcessor(new MathSingleLeftProcessor());
        defaultInterpret.addContextProcessor(new MathBinaryBasicProcessor());
        defaultInterpret.addContextProcessor(new MathBinaryBitwiseProcessor());
        defaultInterpret.addContextProcessor(new MathCompareRelationalProcessor());
        defaultInterpret.addContextProcessor(new MathConditionalTernaryProcessor());
        defaultInterpret.addContextProcessor(new MathBinaryShiftProcessor());
        defaultInterpret.addContextProcessor(new MathBinaryRightProcessor());
        defaultInterpret.addContextProcessor(new MathLogicalConnectProcessor());
        defaultInterpret.addContextProcessor(new InstanceofContextProcessor());
        defaultInterpret.addContextProcessor(new LambdaExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new CustomScriptExpressionContextProcessor());
        defaultInterpret.addContextProcessor(new InContextProcessor());
        defaultInterpret.addContextProcessor(new NotInContextProcessor());
    }
}

