/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.attribute;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.tinyscript.interpret.AttributeProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class FieldAttributeProcessor
implements AttributeProcessor {
    private Map<Class<?>, Map<String, Field>> fieldCache = new HashMap();

    @Override
    public boolean isMatch(Object object, Object name) {
        return name instanceof String;
    }

    @Override
    public Object getAttribute(Object object, Object name) throws Exception {
        String fieldName = name.toString();
        Map<String, Field> stringFieldMap = this.fieldCache.get(fieldName);
        Field field = null;
        if (stringFieldMap != null) {
            field = stringFieldMap.get(fieldName);
        }
        if (field == null && (field = object instanceof Class ? ((Class)object).getField(fieldName) : object.getClass().getField(fieldName)) != null) {
            if (Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
                if (stringFieldMap == null) {
                    stringFieldMap = new HashMap<String, Field>();
                    this.fieldCache.put(object.getClass(), stringFieldMap);
                }
                stringFieldMap.put(fieldName, field);
            } else {
                field = null;
            }
        }
        if (field != null) {
            return field.get(object);
        }
        throw new NotMatchException();
    }
}

