/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.attribute;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.tinygroup.tinyscript.interpret.AttributeProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class MethodAttributeProcessor
implements AttributeProcessor {
    private Map<Class<?>, Map<String, Method>> methodCache = new HashMap();
    private PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();

    @Override
    public boolean isMatch(Object object, Object name) {
        return name instanceof String;
    }

    @Override
    public Object getAttribute(Object object, Object name) throws Exception {
        PropertyDescriptor descriptor;
        String fieldName = name.toString();
        Map<String, Method> stringMethodMap = this.methodCache.get(object.getClass());
        Method method = null;
        if (stringMethodMap != null) {
            method = stringMethodMap.get(fieldName);
        }
        if (method == null && (descriptor = this.propertyUtilsBean.getPropertyDescriptor(object, fieldName)) != null && descriptor.getReadMethod() != null) {
            method = object.getClass().getMethod(descriptor.getReadMethod().getName(), new Class[0]);
            method.setAccessible(true);
            if (stringMethodMap == null) {
                stringMethodMap = new HashMap<String, Method>();
                this.methodCache.put(object.getClass(), stringMethodMap);
            }
            stringMethodMap.put(fieldName, method);
        }
        if (method != null) {
            return method.invoke(object, new Object[0]);
        }
        throw new NotMatchException();
    }
}

