/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.call;

import java.lang.reflect.Method;
import javassist.Modifier;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ExpressionParameter;
import org.tinygroup.tinyscript.interpret.FunctionCallProcessor;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public abstract class AbstractMethodProcessor
implements FunctionCallProcessor {
    @Override
    public boolean enableExpressionParameter() {
        return false;
    }

    @Override
    public Object invoke(ScriptSegment segment, ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        if (this.enableExpressionParameter()) {
            return this.invokeMethod(segment, context, object, methodName, parameters);
        }
        Object[] newParameters = null;
        try {
            newParameters = this.convertParameters(parameters);
        }
        catch (Exception e) {
            throw new NotMatchException();
        }
        return this.invokeMethod(segment, context, object, methodName, newParameters);
    }

    protected Object[] convertParameters(Object[] parameters) throws Exception {
        if (parameters == null || parameters.length == 0) {
            return parameters;
        }
        Object[] newParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            newParameters[i] = parameters[i] != null && parameters[i] instanceof ExpressionParameter ? ((ExpressionParameter)parameters[i]).eval() : parameters[i];
        }
        return newParameters;
    }

    protected abstract Object invokeMethod(ScriptSegment var1, ScriptContext var2, Object var3, String var4, Object ... var5) throws Exception;

    protected boolean containsLambda(Object ... parameters) {
        if (parameters != null && parameters.length > 0) {
            for (Object p : parameters) {
                if (p == null || !(p instanceof LambdaFunction)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean containsNull(Object ... parameters) {
        if (parameters != null && parameters.length > 0) {
            for (Object p : parameters) {
                if (p != null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkName(Method method, String methodName) {
        if (method != null) {
            return method.getName().equals(methodName);
        }
        return false;
    }

    protected boolean checkStatic(Method method) {
        return Modifier.isStatic((int)method.getModifiers());
    }

    protected boolean checkParameter(Method method, Object ... parameters) {
        int m = method.getParameterTypes() == null ? 0 : method.getParameterTypes().length;
        int n = parameters == null ? 0 : parameters.length;
        return m == n;
    }
}

