/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.call;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.call.AbstractMethodProcessor;
import org.tinygroup.tinyscript.interpret.call.JavaMethodUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class JavaMethodProcessor
extends AbstractMethodProcessor {
    private static final Object[] EMPTY_ARGS = new Object[0];

    @Override
    protected Object invokeMethod(ScriptSegment segment, ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        if (object != null) {
            if (this.containsLambda(parameters)) {
                return this.invokeMethodWithWrapper(context, object, methodName, parameters);
            }
            return this.invokeJavaMethod(object, methodName, parameters);
        }
        throw new NotMatchException();
    }

    private Object invokeJavaMethod(Object object, String methodName, Object[] parameters) throws Exception {
        try {
            List<Method> methods = JavaMethodUtil.getClassMethod(object.getClass(), methodName);
            if (methods == null) {
                throw new NoSuchMethodException(ResourceBundleUtil.getDefaultMessage("java.run.error2", object.getClass().getName(), methodName));
            }
            for (Method method : methods) {
                Object[] newArgs = this.dealCommonParameters(method, parameters);
                if (newArgs == null) continue;
                method.setAccessible(true);
                return method.invoke(object, newArgs);
            }
            throw new NoSuchMethodException(ResourceBundleUtil.getDefaultMessage("java.run.error3", object.getClass().getName(), methodName));
        }
        catch (InvocationTargetException e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("java.run.error1", object.getClass().getName(), methodName), e.getTargetException());
        }
        catch (Exception e) {
            throw new NotMatchException(e);
        }
    }

    private Object[] dealCommonParameters(Method method, Object[] parameters) {
        Class<?>[] types = method.getParameterTypes();
        int m = types == null ? 0 : types.length;
        int n = parameters == null ? 0 : parameters.length;
        boolean hasVarArgs = method.isVarArgs();
        if (hasVarArgs) {
            if (m == 1 && n == 0) {
                return EMPTY_ARGS;
            }
            if (m > 1 && n >= m - 1) {
                Object[] newArgs = new Object[m];
                for (int i = 0; i < m - 1; ++i) {
                    if (!JavaMethodUtil.isInstance(types[i], parameters[i])) {
                        return null;
                    }
                    newArgs[i] = parameters[i];
                }
                if (n == m - 1) {
                    newArgs[m - 1] = EMPTY_ARGS;
                } else {
                    Object dynamicArray = Array.newInstance(types[m - 1].getComponentType(), n - m + 1);
                    for (int i = 0; i <= n - m; ++i) {
                        Array.set(dynamicArray, i, parameters[m - 1 + i]);
                    }
                    newArgs[m - 1] = dynamicArray;
                }
                return newArgs;
            }
        } else {
            if (m == 0 && n == 0) {
                return EMPTY_ARGS;
            }
            if (m == n) {
                for (int i = 0; i < n; ++i) {
                    if (JavaMethodUtil.isInstance(types[i], parameters[i])) continue;
                    return null;
                }
                return parameters;
            }
        }
        return null;
    }

    private Object invokeMethodWithWrapper(ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        try {
            List<Method> methods = JavaMethodUtil.getClassMethod(object.getClass(), methodName);
            if (methods == null) {
                throw new NoSuchMethodException(ResourceBundleUtil.getDefaultMessage("java.run.error2", object.getClass().getName(), methodName));
            }
            for (Method method : methods) {
                Object[] newArgs = this.dealLambdaParameters(context, method, parameters);
                if (newArgs == null) continue;
                method.setAccessible(true);
                return method.invoke(object, newArgs);
            }
            throw new NoSuchMethodException(ResourceBundleUtil.getDefaultMessage("java.run.error3", object.getClass().getName(), methodName));
        }
        catch (InvocationTargetException e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("java.run.error1", object.getClass().getName(), methodName), e.getTargetException());
        }
        catch (Exception e) {
            throw new NotMatchException();
        }
    }

    private Object[] dealLambdaParameters(ScriptContext context, Method method, Object[] parameters) {
        Class<?>[] types = method.getParameterTypes();
        int m = types == null ? 0 : types.length;
        int n = parameters == null ? 0 : parameters.length;
        boolean hasVarArgs = method.isVarArgs();
        if (hasVarArgs) {
            if (m == 1 && n == 0) {
                return EMPTY_ARGS;
            }
            if (m > 1 && n >= m - 1) {
                Object[] newArgs = new Object[m];
                for (int i = 0; i < m - 1; ++i) {
                    if (parameters[i] != null && !(parameters[i] instanceof LambdaFunction) && !JavaMethodUtil.isInstance(types[i], parameters[i])) {
                        return null;
                    }
                    newArgs[i] = JavaMethodUtil.convert(context, types[i], parameters[i]);
                }
                if (n == m - 1) {
                    newArgs[m - 1] = EMPTY_ARGS;
                } else {
                    Object dynamicArray = Array.newInstance(types[m - 1].getComponentType(), n - m + 1);
                    for (int i = 0; i <= n - m; ++i) {
                        Array.set(dynamicArray, i, parameters[m - 1 + i]);
                    }
                    newArgs[m - 1] = dynamicArray;
                }
                return newArgs;
            }
        } else {
            if (m == 0 && n == 0) {
                return EMPTY_ARGS;
            }
            if (m == n) {
                Object[] newArgs = new Object[n];
                for (int i = 0; i < n; ++i) {
                    if (parameters[i] != null && !(parameters[i] instanceof LambdaFunction) && !JavaMethodUtil.isInstance(types[i], parameters[i])) {
                        return null;
                    }
                    newArgs[i] = JavaMethodUtil.convert(context, types[i], parameters[i]);
                }
                return newArgs;
            }
        }
        return null;
    }
}

