/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.call;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.interpret.call.InstanceRule;
import org.tinygroup.tinyscript.interpret.call.LambdaRule;
import org.tinygroup.tinyscript.interpret.call.MethodParameterRule;
import org.tinygroup.tinyscript.interpret.call.NullValueRule;
import org.tinygroup.tinyscript.interpret.call.SimpleTypeRule;

public class JavaMethodUtil {
    private static List<MethodParameterRule> rules = new ArrayList<MethodParameterRule>();
    private static Map<Class<?>, Map<String, List<Method>>> methodCache = new HashMap();
    private static Map<Class<?>, Class<?>> simpleClassTypes = new HashMap();
    private static Comparator<Method> methodComparator = new MethodComparator();

    public static void addMethodParameterRule(MethodParameterRule rule) {
        for (MethodParameterRule methodParameterRule : rules) {
            if (!methodParameterRule.equals(rule) && !methodParameterRule.getClass().isInstance(rule)) continue;
            return;
        }
        rules.add(rule);
    }

    public static void removeMethodParameterRule(MethodParameterRule rule) {
        rules.remove(rule);
    }

    public static void addClassMethod(Class<?> clazz) {
        HashMap<String, ArrayList<Method>> classMethodMap = new HashMap<String, ArrayList<Method>>();
        Method[] methods = clazz.getMethods();
        if (methods != null) {
            for (Method method : methods) {
                ArrayList<Method> list = (ArrayList<Method>)classMethodMap.get(method.getName());
                if (list == null) {
                    list = new ArrayList<Method>();
                    classMethodMap.put(method.getName(), list);
                }
                list.add(method);
            }
            for (List list : classMethodMap.values()) {
                Collections.sort(list, methodComparator);
            }
        }
        methodCache.put(clazz, classMethodMap);
    }

    public static void removeClassMethod(Class<?> clazz) {
        methodCache.remove(clazz);
    }

    public static List<Method> getClassMethod(Class<?> clazz, String methodName) {
        Map<String, List<Method>> classMethodMap = methodCache.get(clazz);
        if (classMethodMap == null) {
            JavaMethodUtil.addClassMethod(clazz);
            classMethodMap = methodCache.get(clazz);
        }
        return classMethodMap.get(methodName);
    }

    public static boolean isInstance(Class<?> type, Object value) {
        if (simpleClassTypes.containsKey(type)) {
            if (value == null) {
                return false;
            }
            return simpleClassTypes.get(type).isInstance(value);
        }
        if (value == null) {
            return true;
        }
        return type.isInstance(value);
    }

    public static Object clone(Object object) throws Exception {
        return MethodUtils.invokeMethod((Object)object, (String)"clone", null);
    }

    public static Object safeClone(Object object) {
        try {
            return JavaMethodUtil.clone(object);
        }
        catch (Exception e) {
            return object;
        }
    }

    static boolean checkMethod(Method method, Object[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return true;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            MethodParameterRule p = JavaMethodUtil.findMethodParameterRule(parameterType, parameters[i]);
            if (p != null) continue;
            return false;
        }
        return true;
    }

    static MethodParameterRule findMethodParameterRule(Class<?> parameterType, Object parameter) {
        for (MethodParameterRule rule : rules) {
            if (!rule.isMatch(parameterType, parameter)) continue;
            return rule;
        }
        return null;
    }

    static Object[] wrapper(ScriptContext context, Method method, Object[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return parameters;
        }
        Object[] newParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            MethodParameterRule p = JavaMethodUtil.findMethodParameterRule(parameterType, parameters[i]);
            newParameters[i] = p != null ? p.convert(context, parameterType, parameters[i]) : parameters[i];
        }
        return newParameters;
    }

    static Object convert(ScriptContext context, Class<?> parameterType, Object parameter) {
        MethodParameterRule p = JavaMethodUtil.findMethodParameterRule(parameterType, parameter);
        if (p != null) {
            return p.convert(context, parameterType, parameter);
        }
        return parameter;
    }

    static {
        simpleClassTypes.put(Boolean.TYPE, Boolean.class);
        simpleClassTypes.put(Byte.TYPE, Byte.class);
        simpleClassTypes.put(Character.TYPE, Character.class);
        simpleClassTypes.put(Short.TYPE, Short.class);
        simpleClassTypes.put(Integer.TYPE, Integer.class);
        simpleClassTypes.put(Long.TYPE, Long.class);
        simpleClassTypes.put(Float.TYPE, Float.class);
        simpleClassTypes.put(Double.TYPE, Double.class);
        JavaMethodUtil.addMethodParameterRule(new NullValueRule());
        JavaMethodUtil.addMethodParameterRule(new InstanceRule());
        JavaMethodUtil.addMethodParameterRule(new SimpleTypeRule());
        JavaMethodUtil.addMethodParameterRule(new LambdaRule());
    }

    static class MethodComparator
    implements Comparator<Method> {
        MethodComparator() {
        }

        @Override
        public int compare(Method m1, Method m2) {
            int n2;
            int n1 = this.countMethod(m1);
            if (n1 > (n2 = this.countMethod(m2))) {
                return 1;
            }
            if (n1 < n2) {
                return -1;
            }
            return 0;
        }

        private int countMethod(Method m) {
            int prime = 31;
            int result = 1;
            Class<?>[] types = m.getParameterTypes();
            if (types != null) {
                for (Class<?> type : types) {
                    result = type.equals(Object.class) ? result * 31 + 2 : result * 31 + 1;
                }
            }
            return result;
        }
    }
}

