/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.call;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.call.AbstractMethodProcessor;
import org.tinygroup.tinyscript.interpret.call.JavaMethodUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class JavaStaticMethodProcessor
extends AbstractMethodProcessor {
    @Override
    protected Object invokeMethod(ScriptSegment segment, ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        if (object instanceof Class) {
            Class clazz = (Class)object;
            if (this.containsLambda(parameters) || this.containsNull(parameters)) {
                return this.invokeMethodWithWrapper(context, clazz, methodName, parameters);
            }
            return this.invokeJavaMethod(clazz, methodName, parameters);
        }
        throw new NotMatchException();
    }

    private Object invokeJavaMethod(Class<?> clazz, String methodName, Object ... parameters) throws Exception {
        try {
            return MethodUtils.invokeStaticMethod(clazz, (String)methodName, (Object[])parameters);
        }
        catch (InvocationTargetException e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("java.run.error4", clazz.getName(), methodName), e.getTargetException());
        }
        catch (Exception e) {
            throw new NotMatchException(e);
        }
    }

    private Object invokeMethodWithWrapper(ScriptContext context, Class<?> clazz, String methodName, Object ... parameters) throws Exception {
        try {
            Method[] methods = clazz.getMethods();
            if (methods != null) {
                for (Method method : methods) {
                    if (!this.checkName(method, methodName) || !this.checkStatic(method) || !this.checkParameter(method, parameters) || !JavaMethodUtil.checkMethod(method, parameters)) continue;
                    Object[] newParameters = JavaMethodUtil.wrapper(context, method, parameters);
                    return method.invoke(null, newParameters);
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("java.run.error4", clazz.getName(), methodName), e.getTargetException());
        }
        catch (Exception e) {
            throw new NotMatchException(e);
        }
        throw new NotMatchException();
    }
}

