/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.call;

import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.call.AbstractMethodProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class ScriptClassInstanceProcessor
extends AbstractMethodProcessor {
    @Override
    protected Object invokeMethod(ScriptSegment segment, ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        ScriptClassInstance instance = ScriptContextUtil.getScriptClassInstance(context);
        if (instance != null) {
            if (instance.getScriptClass().getScriptMethod(methodName) != null) {
                return instance.execute(context, methodName, parameters);
            }
            if (this.isGetMethod(instance, methodName, parameters)) {
                String fieldName = this.getFieldName(methodName);
                return instance.getField(fieldName);
            }
            if (this.isSetMethod(instance, methodName, parameters)) {
                String fieldName = this.getFieldName(methodName);
                instance.setField(fieldName, parameters[0]);
                return null;
            }
        }
        throw new NotMatchException();
    }

    private boolean isGetMethod(ScriptClassInstance instance, String methodName, Object ... parameters) {
        if (methodName.startsWith("get") && (parameters == null || parameters.length == 0)) {
            String fieldName = this.getFieldName(methodName);
            return instance.existField(fieldName);
        }
        return false;
    }

    private boolean isSetMethod(ScriptClassInstance instance, String methodName, Object ... parameters) {
        if (methodName.startsWith("set") && parameters != null && parameters.length == 1) {
            String fieldName = this.getFieldName(methodName);
            return instance.existField(fieldName);
        }
        return false;
    }

    private String getFieldName(String methodName) {
        if (methodName != null && methodName.length() >= 4) {
            String first = methodName.substring(3, 4).toLowerCase();
            return first + methodName.substring(4);
        }
        return null;
    }
}

