/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.call;

import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptFunction;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.DynamicNameScriptFunction;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.call.AbstractMethodProcessor;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class ScriptFunctionProcessor
extends AbstractMethodProcessor {
    @Override
    public boolean enableExpressionParameter() {
        return true;
    }

    @Override
    protected Object invokeMethod(ScriptSegment segment, ScriptContext context, Object object, String methodName, Object ... parameters) throws Exception {
        ScriptFunction function = segment.getScriptEngine().findScriptFunction(object, methodName);
        if (function != null) {
            try {
                if (function instanceof DynamicNameScriptFunction) {
                    ScriptContextUtil.addDynamicFunctionName(context, methodName);
                }
                if (object == null) {
                    if (function.enableExpressionParameter()) {
                        Object object2 = function.execute(segment, context, parameters);
                        return object2;
                    }
                    Object object3 = function.execute(segment, context, this.convertParameters(parameters));
                    return object3;
                }
                Object[] newParameters = new Object[(parameters == null ? 1 : parameters.length) + 1];
                newParameters[0] = object;
                if (parameters != null && parameters.length > 0) {
                    System.arraycopy(parameters, 0, newParameters, 1, parameters.length);
                }
                if (function.enableExpressionParameter()) {
                    Object object4 = function.execute(segment, context, newParameters);
                    return object4;
                }
                Object object5 = function.execute(segment, context, this.convertParameters(newParameters));
                return object5;
            }
            catch (NotMatchException e) {
                throw e;
            }
            catch (ScriptException e) {
                throw e;
            }
            finally {
                if (function instanceof DynamicNameScriptFunction) {
                    ScriptContextUtil.removeDynamicFunctionName(context, methodName);
                }
            }
        }
        throw new NotMatchException();
    }
}

