/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.context;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.impl.ArrayScriptContext;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.ScriptUtil;
import org.tinygroup.tinyscript.interpret.exception.RunScriptException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class ArrayCreatorContextProcessor
implements ParserRuleContextProcessor<TinyScriptParser.ArrayCreatorContext> {
    @Override
    public Class<TinyScriptParser.ArrayCreatorContext> getType() {
        return TinyScriptParser.ArrayCreatorContext.class;
    }

    @Override
    public ScriptResult process(TinyScriptParser.ArrayCreatorContext parseTree, ScriptInterpret interpret, ScriptSegment segment, ScriptContext context) throws Exception {
        String className = null;
        try {
            className = parseTree.qualifiedName().getText();
            List<TinyScriptParser.DimContext> dimContextList = parseTree.dims().dim();
            int[] dimensions = new int[dimContextList.size()];
            Class<?> componentType = ScriptUtil.findJavaClass(className, segment, null);
            if (componentType == null) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.array.error1", className));
            }
            Object array = null;
            Arrays.fill(dimensions, -1);
            for (int i = 0; i < dimensions.length; ++i) {
                TinyScriptParser.DimContext dimContext = dimContextList.get(i);
                if (dimContext.expression() == null) continue;
                dimensions[i] = (Integer)interpret.interpretParseTreeValue((ParseTree)dimContext.expression(), segment, context);
                if (dimensions[i] >= 0) continue;
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.array.error2", className, i));
            }
            ArrayScriptContext arrayScriptContext = null;
            if (parseTree.arrayInitializer() != null) {
                arrayScriptContext = (ArrayScriptContext)interpret.interpretParseTreeValue((ParseTree)parseTree.arrayInitializer(), segment, context);
            }
            boolean emptyTag = false;
            for (int i = 0; i < dimensions.length; ++i) {
                if (dimensions[i] >= 0) continue;
                emptyTag = true;
                break;
            }
            if (emptyTag && arrayScriptContext == null) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.array.error3", className));
            }
            if (emptyTag && arrayScriptContext != null) {
                Integer[] dataDims = arrayScriptContext.getDimsToLeaf();
                if (dimensions.length != dataDims.length) {
                    throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.array.error4", className, dimensions.length, dataDims.length));
                }
                for (int i = 0; i < dimensions.length; ++i) {
                    if (dimensions[i] >= 0) continue;
                    dimensions[i] = dataDims[i];
                }
            }
            if (arrayScriptContext != null) {
                array = Array.newInstance(componentType, dimensions);
                Iterator<ArrayScriptContext.Element> iterator = arrayScriptContext.iterator();
                while (iterator.hasNext()) {
                    ArrayScriptContext.Element element = iterator.next();
                    Object a = this.getArray(array, element.getItems());
                    Array.set(a, element.getIndex(), element.getValue());
                }
            } else {
                array = Array.newInstance(componentType, dimensions);
            }
            return new ScriptResult(array);
        }
        catch (Exception e) {
            throw new RunScriptException(e, (ParseTree)parseTree, segment, 3, ResourceBundleUtil.getDefaultMessage("context.array.error5", className));
        }
    }

    private Object getArray(Object array, Integer[] dims) {
        Object result = null;
        if (dims.length == 0) {
            return array;
        }
        for (int i = 0; i < dims.length; ++i) {
            result = i == 0 ? Array.get(array, dims[i]) : Array.get(result, dims[i]);
        }
        return result;
    }
}

