/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.impl.DefaultScriptContext;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.exception.BreakException;
import org.tinygroup.tinyscript.interpret.exception.ContinueException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class ForContextProcessor
implements ParserRuleContextProcessor<TinyScriptParser.ForContext> {
    @Override
    public Class<TinyScriptParser.ForContext> getType() {
        return TinyScriptParser.ForContext.class;
    }

    @Override
    public ScriptResult process(TinyScriptParser.ForContext parseTree, ScriptInterpret interpret, ScriptSegment segment, ScriptContext context) throws Exception {
        TinyScriptParser.ForControlContext forControlContext = parseTree.forControl();
        DefaultScriptContext forScriptContext = new DefaultScriptContext();
        HashSet<String> paramNames = new HashSet<String>();
        if (forControlContext.enhancedForControl() != null) {
            String name = forControlContext.enhancedForControl().Identifier().getText();
            paramNames.add(name);
            forScriptContext.setParent(context);
            Iterator it = ExpressionUtil.getIterator(interpret.interpretParseTreeValue((ParseTree)forControlContext.enhancedForControl().expression(), segment, forScriptContext));
            while (it.hasNext()) {
                forScriptContext.put(name, it.next());
                try {
                    interpret.interpretParseTree((ParseTree)parseTree.statement(), segment, forScriptContext);
                }
                catch (ContinueException e) {
                }
                catch (BreakException e) {
                    break;
                }
            }
        } else {
            List<String> names = null;
            forScriptContext.setParent(context);
            if (forControlContext.forInit() != null) {
                interpret.interpretParseTree((ParseTree)forControlContext.forInit(), segment, forScriptContext);
                names = this.getForInitParamNames(forControlContext.forInit());
                paramNames.addAll(names);
            }
            boolean runtag = true;
            if (forControlContext.expression() != null) {
                runtag = ExpressionUtil.getBooleanValue(interpret.interpretParseTreeValue((ParseTree)forControlContext.expression(), segment, forScriptContext));
            }
            while (runtag) {
                try {
                    interpret.interpretParseTree((ParseTree)parseTree.statement(), segment, forScriptContext);
                    if (forControlContext.forUpdate() != null) {
                        interpret.interpretParseTree((ParseTree)forControlContext.forUpdate(), segment, forScriptContext);
                    }
                    if (forControlContext.expression() == null) continue;
                    runtag = ExpressionUtil.getBooleanValue(interpret.interpretParseTreeValue((ParseTree)forControlContext.expression(), segment, forScriptContext));
                }
                catch (ContinueException e) {
                    if (forControlContext.forUpdate() != null) {
                        interpret.interpretParseTree((ParseTree)forControlContext.forUpdate(), segment, forScriptContext);
                    }
                    if (forControlContext.expression() == null) continue;
                    runtag = ExpressionUtil.getBooleanValue(interpret.interpretParseTreeValue((ParseTree)forControlContext.expression(), segment, forScriptContext));
                }
                catch (BreakException e) {
                    // empty catch block
                    break;
                }
            }
        }
        for (Map.Entry entry : forScriptContext.getItemMap().entrySet()) {
            if (paramNames.contains(entry.getKey())) continue;
            context.put((String)entry.getKey(), entry.getValue());
        }
        return ScriptResult.VOID_RESULT;
    }

    private List<String> getForInitParamNames(TinyScriptParser.ForInitContext forInitContext) {
        ArrayList<String> names = new ArrayList<String>();
        if (forInitContext.localVariableDeclaration() != null) {
            for (TinyScriptParser.VariableDeclaratorContext variableDeclaratorContext : forInitContext.localVariableDeclaration().variableDeclarators().variableDeclarator()) {
                names.add(variableDeclaratorContext.Identifier().getText());
            }
        }
        return names;
    }
}

