/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.context;

import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.impl.ScriptMethodContext;
import org.tinygroup.tinyscript.interpret.FunctionCallUtil;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.call.FunctionCallExpressionParameter;
import org.tinygroup.tinyscript.interpret.exception.RunScriptException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class FunctionCallExpressionContextProcessor
implements ParserRuleContextProcessor<TinyScriptParser.FunctionCallExpressionContext> {
    @Override
    public Class<TinyScriptParser.FunctionCallExpressionContext> getType() {
        return TinyScriptParser.FunctionCallExpressionContext.class;
    }

    @Override
    public ScriptResult process(TinyScriptParser.FunctionCallExpressionContext parseTree, ScriptInterpret interpret, ScriptSegment segment, ScriptContext context) throws Exception {
        String name = null;
        try {
            Object value;
            Object object = interpret.interpretParseTreeValue((ParseTree)parseTree.expression(), segment, context);
            name = parseTree.Identifier().getText();
            ScriptMethodContext scriptMethodContext = new ScriptMethodContext();
            scriptMethodContext.setParent(context);
            if (object instanceof ScriptClassInstance) {
                scriptMethodContext.setScriptClassInstance((ScriptClassInstance)object);
            }
            ArrayList<FunctionCallExpressionParameter> paraList = new ArrayList<FunctionCallExpressionParameter>();
            if (parseTree.expressionList() != null) {
                for (TinyScriptParser.ExpressionContext expressionContext : parseTree.expressionList().expression()) {
                    if (expressionContext == null) continue;
                    paraList.add(new FunctionCallExpressionParameter(expressionContext, segment, context));
                }
            }
            if ((value = FunctionCallUtil.operate(segment, scriptMethodContext, object, name, paraList.toArray())) != null && value instanceof ScriptResult) {
                return (ScriptResult)value;
            }
            return new ScriptResult(value);
        }
        catch (NoSuchMethodException e) {
            throw new RunScriptException(e, (ParseTree)parseTree, segment, 31, ResourceBundleUtil.getDefaultMessage("context.call.error1", name));
        }
        catch (Exception e) {
            throw new RunScriptException(e, (ParseTree)parseTree, segment, 31, ResourceBundleUtil.getDefaultMessage("context.call.error2", name));
        }
    }
}

