/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.context;

import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.context.Context;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.call.JavaMethodUtil;
import org.tinygroup.tinyscript.interpret.exception.ReturnException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class LambdaExpressionContextProcessor
implements ParserRuleContextProcessor<TinyScriptParser.LambdaExpressionContext> {
    @Override
    public Class<TinyScriptParser.LambdaExpressionContext> getType() {
        return TinyScriptParser.LambdaExpressionContext.class;
    }

    @Override
    public ScriptResult process(TinyScriptParser.LambdaExpressionContext parseTree, ScriptInterpret interpret, ScriptSegment segment, ScriptContext context) throws Exception {
        try {
            InnerLambdaFunction lambdaFunction = new InnerLambdaFunction(parseTree, interpret, segment);
            if (lambdaFunction.getFunctionName() == null) {
                return new ScriptResult(lambdaFunction);
            }
            ScriptContextUtil.setLambdaFunction(context, lambdaFunction);
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.lambda.error1", this.getType(), parseTree.getText()), e);
        }
        return ScriptResult.VOID_RESULT;
    }

    class InnerLambdaFunction
    implements LambdaFunction {
        private String functionName;
        private String[] parameterNames;
        private TinyScriptParser.LambdaBodyContext lambdaBodyContext;
        private ScriptInterpret interpret;
        private ScriptSegment segment;

        public InnerLambdaFunction(TinyScriptParser.LambdaExpressionContext lambdaExpressionContext, ScriptInterpret interpret, ScriptSegment segment) {
            this.interpret = interpret;
            this.segment = segment;
            TinyScriptParser.LambdaParametersContext lambdaParameters = lambdaExpressionContext.lambdaParameters();
            if (lambdaParameters.Identifier() != null) {
                if (lambdaParameters.getChildCount() >= 3) {
                    this.functionName = lambdaParameters.Identifier().getText();
                } else if (lambdaParameters.getChildCount() == 1) {
                    this.parameterNames = new String[1];
                    this.parameterNames[0] = lambdaParameters.Identifier().getText();
                }
            }
            if (lambdaParameters.expressionList() != null) {
                List<TinyScriptParser.ExpressionContext> expressionList = lambdaParameters.expressionList().expression();
                this.parameterNames = new String[expressionList.size()];
                for (int i = 0; i < expressionList.size(); ++i) {
                    this.parameterNames[i] = expressionList.get(i).getText();
                }
            }
            this.lambdaBodyContext = lambdaExpressionContext.lambdaBody();
        }

        @Override
        public String getFunctionName() {
            return this.functionName;
        }

        @Override
        public String[] getParamterNames() {
            return this.parameterNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScriptResult execute(ScriptContext context, Object ... parameters) throws Exception {
            if (!(this.parameterNames != null && this.parameterNames.length != 0 || parameters != null && parameters.length != 0)) {
                return this.executeLambda(context);
            }
            if (this.parameterNames != null && parameters != null && this.parameterNames.length == parameters.length) {
                for (int i = 0; i < this.parameterNames.length; ++i) {
                    context.getItemMap().put(this.parameterNames[i], JavaMethodUtil.safeClone(parameters[i]));
                }
                try {
                    ScriptResult scriptResult = this.executeLambda(context);
                    return scriptResult;
                }
                finally {
                    this.synValue(context);
                }
            }
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("context.lambda.error2"));
        }

        private void synValue(ScriptContext context) {
            Map map = context.getItemMap();
            for (String key : map.keySet()) {
                Map<String, Object> parentMap;
                if (!this.checkKey(key) || (parentMap = this.findItemMap(context.getParent(), key)) == null) continue;
                parentMap.put(key, map.get(key));
            }
        }

        private boolean checkKey(String key) {
            return !key.startsWith("$");
        }

        private Map<String, Object> findItemMap(Context context, String key) {
            if (context != null) {
                if (context.getItemMap().containsKey(key)) {
                    return context.getItemMap();
                }
                return this.findItemMap(context.getParent(), key);
            }
            return null;
        }

        private ScriptResult executeLambda(ScriptContext context) throws Exception {
            try {
                return this.interpret.interpretParseTree((ParseTree)this.lambdaBodyContext, this.segment, context);
            }
            catch (ReturnException e) {
                return new ScriptResult(e.getValue());
            }
            catch (Exception e) {
                throw new ScriptException(null, e);
            }
        }
    }
}

