/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.context;

import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.assignvalue.AssignValueUtil;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.exception.RunScriptException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class MathBinaryRightProcessor
implements ParserRuleContextProcessor<TinyScriptParser.BinaryRightExpressionContext> {
    @Override
    public Class<TinyScriptParser.BinaryRightExpressionContext> getType() {
        return TinyScriptParser.BinaryRightExpressionContext.class;
    }

    @Override
    public ScriptResult process(TinyScriptParser.BinaryRightExpressionContext parseTree, ScriptInterpret interpret, ScriptSegment segment, ScriptContext context) throws Exception {
        String name = parseTree.getChild(0).getText();
        String op = parseTree.getChild(1).getText();
        try {
            if ("=".equals(op)) {
                Object value = interpret.interpretParseTreeValue(parseTree.getChild(2), segment, context);
                AssignValueUtil.operate(name, value, context);
                return new ScriptResult(value);
            }
            Object aValue = interpret.interpretParseTreeValue(parseTree.getChild(0), segment, context);
            Object bValue = interpret.interpretParseTreeValue(parseTree.getChild(2), segment, context);
            String newOp = op.substring(0, op.length() - 1);
            Object newValue = ExpressionUtil.executeOperation(newOp, aValue, bValue);
            AssignValueUtil.operate(name, newValue, context);
            return new ScriptResult(newValue);
        }
        catch (Exception e) {
            throw new RunScriptException(e, (ParseTree)parseTree, segment, 33, ResourceBundleUtil.getDefaultMessage("context.math.error2", name, op));
        }
    }
}

