/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.context;

import org.antlr.v4.runtime.tree.ParseTree;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.interpret.ParserRuleContextProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptInterpret;
import org.tinygroup.tinyscript.interpret.ScriptResult;
import org.tinygroup.tinyscript.interpret.exception.RunScriptException;
import org.tinygroup.tinyscript.parser.grammer.TinyScriptParser;

public class MathLogicalConnectProcessor
implements ParserRuleContextProcessor<TinyScriptParser.LogicalConnectExpressionContext> {
    @Override
    public Class<TinyScriptParser.LogicalConnectExpressionContext> getType() {
        return TinyScriptParser.LogicalConnectExpressionContext.class;
    }

    @Override
    public ScriptResult process(TinyScriptParser.LogicalConnectExpressionContext parseTree, ScriptInterpret interpret, ScriptSegment segment, ScriptContext context) throws Exception {
        String name = null;
        String op = null;
        try {
            Object a = interpret.interpretParseTreeValue((ParseTree)parseTree.expression().get(0), segment, context);
            name = parseTree.expression().get(0).getText();
            op = parseTree.getChild(1).getText();
            if (this.checkShortAnd(a, op)) {
                return new ScriptResult(a);
            }
            if (this.checkShortOr(a, op)) {
                return new ScriptResult(a);
            }
            Object b = interpret.interpretParseTreeValue((ParseTree)parseTree.expression().get(1), segment, context);
            return new ScriptResult(ExpressionUtil.executeOperation(op, a, b));
        }
        catch (Exception e) {
            throw new RunScriptException(e, (ParseTree)parseTree, segment, 33, ResourceBundleUtil.getDefaultMessage("context.math.error5", name, op));
        }
    }

    private boolean checkShortAnd(Object obj, String op) {
        if (obj != null && obj instanceof Boolean && "&&".equals(op)) {
            return (Boolean)obj == false;
        }
        return false;
    }

    private boolean checkShortOr(Object obj, String op) {
        if (obj != null && obj instanceof Boolean && "||".equals(op)) {
            return (Boolean)obj;
        }
        return false;
    }
}

