/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.custom;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.custom.CustomProcessor;

public final class CustomUtil {
    private static List<CustomProcessor> customProcessors = new ArrayList<CustomProcessor>();

    private CustomUtil() {
    }

    public static void addCustomProcessor(CustomProcessor processor) {
        for (CustomProcessor customProcessor : customProcessors) {
            if (!customProcessor.equals(processor) && !customProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        customProcessors.add(processor);
    }

    public static void removeCustomProcessor(CustomProcessor processor) {
        customProcessors.remove(processor);
    }

    public static Object executeRule(Object customObj, String customRule, ScriptContext context) throws ScriptException {
        for (CustomProcessor sqlProcessor : customProcessors) {
            if (!sqlProcessor.isMatch(customObj)) continue;
            return sqlProcessor.executeRule(customObj, customRule, context);
        }
        throw new ScriptException(String.format("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7c7b\u578b[%s]\u7684\u81ea\u5b9a\u4e49\u89c4\u5219\u5904\u7406\u5668", customObj.getClass().getName()));
    }
}

