/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.exception;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.InterpretExceptionInfo;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class InterpretFormatException
extends ScriptException {
    private InterpretExceptionInfo info;
    private static final long serialVersionUID = 6187784709978607513L;

    public InterpretFormatException(InterpretExceptionInfo info) {
        this.info = info;
    }

    public InterpretExceptionInfo getInterpretExceptionInfo() {
        return this.info;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        for (Throwable cause = this.info.getSource(); cause != null; cause = cause.getCause()) {
            this.checkCause(causes, cause);
        }
        for (int i = causes.size() - 1; i >= 0; --i) {
            this.formatExceptionMessage(sb, (Throwable)causes.get(i));
        }
        return sb.toString();
    }

    private void checkCause(List<Throwable> causes, Throwable cause) {
        if (cause.getClass().equals(ScriptException.class) && cause.getMessage() == null) {
            return;
        }
        if (causes.size() > 0) {
            for (Throwable old : causes) {
                if (!old.equals(cause)) continue;
                return;
            }
        }
        causes.add(cause);
    }

    protected void formatExceptionMessage(StringBuilder sb, Throwable cause) {
        this.printLine(sb);
        if (cause instanceof InterpretExceptionInfo) {
            InterpretExceptionInfo interpretExceptionInfo = (InterpretExceptionInfo)((Object)cause);
            this.printTypeMessage(sb, interpretExceptionInfo.getExceptionType(), interpretExceptionInfo.getMsg());
            this.printPlaceMessage(sb, interpretExceptionInfo);
            this.printTextMessage(sb, interpretExceptionInfo);
        } else if (cause instanceof ScriptException) {
            ScriptException scriptException = (ScriptException)cause;
            this.printTypeMessage(sb, 3, scriptException.getMessage());
        } else {
            this.printTypeMessage(sb, this.getExceptionType(cause), cause.getMessage());
            this.printClassMessage(sb, cause);
        }
    }

    private int getExceptionType(Throwable cause) {
        if (cause.getClass().getName().startsWith("org.antlr.")) {
            return 2;
        }
        return 4;
    }

    private void printPlaceMessage(StringBuilder sb, InterpretExceptionInfo interpretExceptionInfo) {
        sb.append(ResourceBundleUtil.getDefaultMessage("error.place"));
        if (interpretExceptionInfo.getStopLine() < 0 && interpretExceptionInfo.getStopCharPositionInLine() < 0) {
            sb.append(ResourceBundleUtil.getDefaultMessage("error.two.info", interpretExceptionInfo.getStartLine(), interpretExceptionInfo.getStartCharPositionInLine()));
        } else {
            sb.append(ResourceBundleUtil.getDefaultMessage("error.four.info", interpretExceptionInfo.getStartLine(), interpretExceptionInfo.getStartCharPositionInLine(), interpretExceptionInfo.getStopLine(), interpretExceptionInfo.getStopCharPositionInLine()));
        }
        sb.append("\n");
    }

    private void printTextMessage(StringBuilder sb, InterpretExceptionInfo interpretExceptionInfo) {
        sb.append(ResourceBundleUtil.getDefaultMessage("error.text"));
        if (interpretExceptionInfo.getStartLine() != interpretExceptionInfo.getStopLine()) {
            sb.append("\n");
        }
        sb.append(interpretExceptionInfo.getExceptionScript());
    }

    private void printTypeMessage(StringBuilder sb, int exceptionType, String msg) {
        switch (exceptionType) {
            case 1: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.recognizer"));
                break;
            }
            case 2: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.parser"));
                break;
            }
            case 3: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.running"));
                break;
            }
            case 31: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.function"));
                break;
            }
            case 32: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.field"));
                break;
            }
            case 33: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.expression"));
                break;
            }
            case 34: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.directive"));
                break;
            }
            case 35: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.scriptclass"));
                break;
            }
            case 4: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.other"));
                break;
            }
            default: {
                sb.append(ResourceBundleUtil.getDefaultMessage("error.type.unknown"));
            }
        }
        if (msg != null) {
            sb.append(msg);
        }
        sb.append("\n");
    }

    private void printClassMessage(StringBuilder sb, Object obj) {
        sb.append(ResourceBundleUtil.getDefaultMessage("error.class")).append(obj.getClass().getName()).append("\n");
    }

    private void printLine(StringBuilder sb) {
        sb.append("\n");
    }
}

