/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.exception;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.InnerScriptReader;
import org.tinygroup.tinyscript.interpret.InterpretExceptionInfo;

public class ParserRuleContextException
extends ScriptException
implements InterpretExceptionInfo {
    private static final long serialVersionUID = 3743392233859106251L;
    private transient ParserRuleContext context;
    private InnerScriptReader reader = null;
    private transient Token start;
    private transient Token stop;

    public ParserRuleContextException(RecognitionException e, ParserRuleContext parserRuleContext, String text) {
        super((Throwable)e);
        this.context = parserRuleContext;
        if (text != null) {
            try {
                this.reader = new InnerScriptReader(text);
            }
            catch (Exception ex) {
                this.reader = null;
            }
        }
    }

    private void initToken() {
        if (this.start != null || this.stop != null) {
            return;
        }
        if (this.context.getStop() == null) {
            this.start = this.context.getStart();
        } else if (this.context.getStart().getLine() < this.context.getStop().getLine() || this.context.getStart().getLine() == this.context.getStop().getLine() && this.context.getStart().getCharPositionInLine() < this.context.getStop().getCharPositionInLine()) {
            this.start = this.context.getStart();
            this.stop = this.context.getStop();
        } else {
            this.start = this.context.getStart();
        }
    }

    public Token getStratToken() {
        return this.start;
    }

    public Token getStopToken() {
        return this.stop;
    }

    public String getText() {
        return this.context.getText();
    }

    @Override
    public int getExceptionType() {
        return 2;
    }

    @Override
    public String getExceptionScript() {
        this.initToken();
        try {
            if (this.reader == null) {
                return this.context.getText();
            }
            if (this.stop != null) {
                return this.reader.getScript(this.start.getLine(), this.start.getCharPositionInLine(), this.stop.getLine(), this.stop.getCharPositionInLine());
            }
            return this.reader.getScriptToStop(this.start.getLine(), this.start.getCharPositionInLine());
        }
        catch (Exception e) {
            return this.context.getText();
        }
    }

    @Override
    public int getStartLine() {
        this.initToken();
        return this.start == null ? -1 : this.start.getLine();
    }

    @Override
    public int getStartCharPositionInLine() {
        this.initToken();
        return this.start == null ? -1 : this.start.getCharPositionInLine();
    }

    @Override
    public int getStopLine() {
        this.initToken();
        return this.stop == null ? -1 : this.stop.getLine();
    }

    @Override
    public int getStopCharPositionInLine() {
        this.initToken();
        return this.stop == null ? -1 : this.stop.getCharPositionInLine();
    }

    @Override
    public String getMsg() {
        return null;
    }

    @Override
    public Exception getSource() {
        return this;
    }
}

