/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.exception;

import java.util.regex.Pattern;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Recognizer;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.InnerScriptReader;
import org.tinygroup.tinyscript.interpret.InterpretExceptionInfo;

public class RecognizerException
extends ScriptException
implements InterpretExceptionInfo {
    private static final long serialVersionUID = 3665837093790604968L;
    private static final Pattern EXTRANEOUS_RULE = Pattern.compile("extraneous\\s+input\\s+'.*'\\s+expecting\\s+\\{.*\\}");
    private static final Pattern MISSIING_RULE = Pattern.compile("missing\\s+'.*'\\s+at\\s+'.*'");
    private static final int ERROR_TYPE_EXTRANEOUS = 11;
    private static final int ERROR_TYPE_MISSING = 12;
    private int exceptionType = -1;
    private int startLine;
    private int startCharPositionInLine;
    private int stopLine = -1;
    private int stopCharPositionInLine = -1;
    private String msg;
    private InnerScriptReader reader = null;

    public RecognizerException(Recognizer<?, ?> recognizer, CommonToken commonToken, int codeLine, int codeCharPositionInLine, String errorMsg) {
        this.msg = errorMsg;
        this.exceptionType = this.dealExceptionType(this.msg);
        if (this.exceptionType == 11 || this.exceptionType == 12) {
            this.initMissing(recognizer, commonToken);
        } else {
            this.initDefault(recognizer, codeLine, codeCharPositionInLine);
        }
    }

    private int dealExceptionType(String msg) {
        if (EXTRANEOUS_RULE.matcher(msg).find()) {
            return 11;
        }
        if (MISSIING_RULE.matcher(msg).find()) {
            return 12;
        }
        return 1;
    }

    private void initMissing(Recognizer<?, ?> recognizer, CommonToken commonToken) {
        try {
            this.startLine = 1;
            this.startCharPositionInLine = 0;
            this.stopLine = commonToken.getLine();
            this.stopCharPositionInLine = commonToken.getCharPositionInLine();
            String text = commonToken.getTokenSource().getInputStream().toString();
            if (text != null) {
                this.reader = new InnerScriptReader(text);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initDefault(Recognizer<?, ?> recognizer, int codeLine, int codeCharPositionInLine) {
        this.startLine = codeLine;
        this.startCharPositionInLine = codeCharPositionInLine;
        try {
            String text = recognizer.getInputStream().toString();
            if (text != null) {
                this.reader = new InnerScriptReader(text);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public int getExceptionType() {
        return 1;
    }

    @Override
    public String getExceptionScript() {
        try {
            if (this.reader != null) {
                if (this.exceptionType == 11 || this.exceptionType == 12) {
                    return this.reader.getScript(this.startLine, this.startCharPositionInLine, this.stopLine, this.stopCharPositionInLine);
                }
                return this.reader.getScriptToStop(this.startLine, this.startCharPositionInLine);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getStartCharPositionInLine() {
        return this.startCharPositionInLine;
    }

    @Override
    public int getStopLine() {
        return this.stopLine;
    }

    @Override
    public int getStopCharPositionInLine() {
        return this.stopCharPositionInLine;
    }

    @Override
    public Exception getSource() {
        return this;
    }
}

