/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.exception;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.InterpretExceptionInfo;

public class RunScriptException
extends ScriptException
implements InterpretExceptionInfo {
    private static final long serialVersionUID = 8470435201340782572L;
    private ParseTree tree;
    private int exceptionType = 3;
    private ScriptSegment segment;
    private String msg;

    public RunScriptException(Exception e, ParseTree tree, ScriptSegment segment) {
        this(e, tree, segment, 3, null);
    }

    public RunScriptException(Exception e, ParseTree tree, ScriptSegment segment, int exceptionType) {
        this(e, tree, segment, exceptionType, null);
    }

    public RunScriptException(Exception e, ParseTree tree, ScriptSegment segment, int exceptionType, String msg) {
        super(e);
        this.tree = tree;
        this.segment = segment;
        this.exceptionType = exceptionType;
        this.msg = msg;
    }

    @Override
    public int getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public String getExceptionScript() {
        try {
            return this.segment.getScript(this.getStartLine(), this.getStartCharPositionInLine(), this.getStopLine(), this.getStopCharPositionInLine());
        }
        catch (ScriptException e) {
            return this.tree.getText();
        }
    }

    @Override
    public int getStartLine() {
        if (this.tree instanceof TerminalNode) {
            TerminalNode terminalNode = (TerminalNode)this.tree;
            return terminalNode.getSymbol().getLine();
        }
        if (this.tree instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)this.tree;
            return parserRuleContext.getStart().getLine();
        }
        return -1;
    }

    @Override
    public int getStartCharPositionInLine() {
        if (this.tree instanceof TerminalNode) {
            TerminalNode terminalNode = (TerminalNode)this.tree;
            return terminalNode.getSymbol().getCharPositionInLine();
        }
        if (this.tree instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)this.tree;
            return parserRuleContext.getStart().getCharPositionInLine();
        }
        return -1;
    }

    @Override
    public int getStopLine() {
        if (this.tree instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)this.tree;
            return parserRuleContext.getStop().getLine();
        }
        return -1;
    }

    @Override
    public int getStopCharPositionInLine() {
        if (this.tree instanceof ParserRuleContext) {
            ParserRuleContext parserRuleContext = (ParserRuleContext)this.tree;
            return parserRuleContext.getStop().getCharPositionInLine();
        }
        return -1;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public Exception getSource() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.exceptionType;
        result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
        result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
        result = 31 * result + (this.tree == null ? 0 : this.tree.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunScriptException other = (RunScriptException)obj;
        if (this.exceptionType != other.exceptionType) {
            return false;
        }
        if (this.msg == null ? other.msg != null : !this.msg.equals(other.msg)) {
            return false;
        }
        if (this.segment == null ? other.segment != null : !this.segment.equals(other.segment)) {
            return false;
        }
        return !(this.tree == null ? other.tree != null : !this.tree.equals(other.tree));
    }
}

