/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.newinstance;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.interpret.newinstance.ConstructorParameterRule;
import org.tinygroup.tinyscript.interpret.newinstance.InstanceRule;
import org.tinygroup.tinyscript.interpret.newinstance.LambdaRule;
import org.tinygroup.tinyscript.interpret.newinstance.SimpleTypeRule;

public class JavaConstructorUtil {
    private static List<ConstructorParameterRule> rules = new ArrayList<ConstructorParameterRule>();

    public static void addConstructorParameterRule(ConstructorParameterRule rule) {
        for (ConstructorParameterRule constructorParameterRule : rules) {
            if (!constructorParameterRule.equals(rule) && !constructorParameterRule.getClass().isInstance(rule)) continue;
            return;
        }
        rules.add(rule);
    }

    public static void removeConstructorParameterRule(ConstructorParameterRule rule) {
        rules.remove(rule);
    }

    static ConstructorParameterRule findConstructorParameterRule(Class<?> parameterType, Object parameter) {
        for (ConstructorParameterRule rule : rules) {
            if (!rule.isMatch(parameterType, parameter)) continue;
            return rule;
        }
        return null;
    }

    static boolean checkConstructor(Constructor<?> c, List<Object> paramList) {
        for (int i = 0; i < paramList.size(); ++i) {
            Object parameter;
            Class<?> parameterType = c.getParameterTypes()[i];
            ConstructorParameterRule rule = JavaConstructorUtil.findConstructorParameterRule(parameterType, parameter = paramList.get(i));
            if (rule != null) continue;
            return false;
        }
        return true;
    }

    static Object[] wrapper(ScriptContext context, Constructor<?> c, List<Object> paramList) {
        Object[] newParameters = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            Object parameter;
            Class<?> parameterType = c.getParameterTypes()[i];
            ConstructorParameterRule rule = JavaConstructorUtil.findConstructorParameterRule(parameterType, parameter = paramList.get(i));
            newParameters[i] = rule != null ? rule.convert(context, parameterType, parameter) : parameter;
        }
        return newParameters;
    }

    static {
        JavaConstructorUtil.addConstructorParameterRule(new InstanceRule());
        JavaConstructorUtil.addConstructorParameterRule(new SimpleTypeRule());
        JavaConstructorUtil.addConstructorParameterRule(new LambdaRule());
    }
}

