/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.newinstance;

import java.lang.reflect.Constructor;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.NewInstanceProcessor;
import org.tinygroup.tinyscript.interpret.ScriptUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;
import org.tinygroup.tinyscript.interpret.newinstance.JavaConstructorUtil;

public class JavaInstanceProcessor
implements NewInstanceProcessor<Class<?>> {
    @Override
    public Class<?> findClass(ScriptSegment classSegment, String className, List<String> importList) {
        return ScriptUtil.findJavaClass(className, classSegment, importList);
    }

    @Override
    public Object newInstance(Class<?> clazz, ScriptContext context, List<Object> paramList) throws Exception {
        if (CollectionUtils.isEmpty(paramList)) {
            return clazz.newInstance();
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!this.checkParameter(constructor, paramList) || !JavaConstructorUtil.checkConstructor(constructor, paramList)) continue;
            Object[] newParameters = JavaConstructorUtil.wrapper(context, constructor, paramList);
            return constructor.newInstance(newParameters);
        }
        throw new NotMatchException();
    }

    private boolean checkParameter(Constructor<?> constructor, List<Object> paramList) {
        int n = constructor.getParameterTypes() == null ? 0 : constructor.getParameterTypes().length;
        int m = paramList == null ? 0 : paramList.size();
        return m == n;
    }
}

