/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.newinstance;

import java.util.List;
import org.springframework.util.CollectionUtils;
import org.tinygroup.tinyscript.ScriptClass;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.NewInstanceProcessor;

public class ScriptClassInstanceProcessor
implements NewInstanceProcessor<ScriptClass> {
    @Override
    public ScriptClass findClass(ScriptSegment segment, String className, List<String> importList) {
        ScriptSegment classSegment = null;
        if (segment.getScriptClass() != null && className.equals(segment.getScriptClass().getClassName())) {
            return segment.getScriptClass();
        }
        classSegment = segment.getScriptEngine().getScriptSegment(className);
        if (classSegment != null) {
            return classSegment.getScriptClass();
        }
        if (!CollectionUtils.isEmpty(importList)) {
            String newClassName = null;
            for (String importPath : importList) {
                if (importPath.endsWith("*")) {
                    newClassName = importPath.substring(0, importPath.length() - 1) + className;
                } else {
                    if (!importPath.endsWith("." + className)) continue;
                    newClassName = importPath;
                }
                if ((classSegment = segment.getScriptEngine().getScriptSegment(newClassName)) == null) continue;
                return classSegment.getScriptClass();
            }
        }
        return null;
    }

    @Override
    public Object newInstance(ScriptClass clazz, ScriptContext context, List<Object> paramList) throws Exception {
        return clazz.newInstance(context, paramList.toArray());
    }
}

