/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.terminal;

import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.terminal.AbstractTerminalNodeProcessor;

public class IntegerNodeProcessor
extends AbstractTerminalNodeProcessor {
    @Override
    public int getType() {
        return 26;
    }

    @Override
    public Object processTerminalNode(TerminalNode terminalNode, ScriptSegment segment, ScriptContext context) throws Exception {
        String s = terminalNode.getText().toLowerCase();
        if (s.endsWith("l")) {
            if (s.startsWith("+")) {
                return this.parseLong(s.substring(1));
            }
            if (s.startsWith("-")) {
                return -this.parseLong(s.substring(1)).longValue();
            }
            return this.parseLong(s);
        }
        if (s.startsWith("+")) {
            return this.parseInteger(s.substring(1));
        }
        if (s.startsWith("-")) {
            return -this.parseInteger(s.substring(1)).intValue();
        }
        return this.parseInteger(s);
    }

    private Long parseLong(String s) {
        if ((s = s.substring(0, s.length() - 1)).startsWith("0x")) {
            return Long.parseLong(s.substring(2), 16);
        }
        if (s.startsWith("0b")) {
            return Long.parseLong(s.substring(2), 2);
        }
        if (s.startsWith("0")) {
            return Long.parseLong(s, 8);
        }
        return Long.parseLong(s, 10);
    }

    private Integer parseInteger(String s) {
        if (s.startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        if (s.startsWith("0b")) {
            return Integer.parseInt(s.substring(2), 2);
        }
        if (s.startsWith("0")) {
            return Integer.parseInt(s, 8);
        }
        return Integer.parseInt(s, 10);
    }
}

