/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.interpret.terminal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.terminal.AbstractTerminalNodeProcessor;

public class StringNodeProcessor
extends AbstractTerminalNodeProcessor {
    private static final String rule = "[$][{][^}]*[}]";
    private static final Pattern pattern = Pattern.compile("[$][{][^}]*[}]");

    @Override
    public int getType() {
        return 30;
    }

    @Override
    public Object processTerminalNode(TerminalNode terminalNode, ScriptSegment segment, ScriptContext context) throws Exception {
        String s = terminalNode.getText();
        s = s.replaceAll("\\\\\"", "\"");
        s = s.replaceAll("[\\\\][\\\\]", "\\\\");
        if (pattern.matcher(s = s.substring(1, s.length() - 1)).find()) {
            Matcher matcher = pattern.matcher(s);
            StringBuilder sb = new StringBuilder();
            int pos = 0;
            while (matcher.find()) {
                String group = matcher.group();
                String script = this.createScript(group);
                sb.append(s.substring(pos, matcher.start()));
                Object value = segment.getScriptEngine().execute(script, context);
                if (value != null) {
                    sb.append(value);
                }
                pos = matcher.end();
            }
            sb.append(s.substring(pos));
            return sb.toString();
        }
        return s;
    }

    protected String createScript(String s) {
        if (!(s = s.substring(2, s.length() - 1)).endsWith(";")) {
            s = s + ";";
        }
        return s;
    }
}

