/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.naming;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.naming.NamingString;
import org.tinygroup.tinyscript.naming.NamingStringEnum;

public abstract class AbstractNamingString
implements NamingString {
    private String source;
    protected List<String> tokens = new ArrayList<String>();

    public AbstractNamingString(String name) {
        this.source = name;
    }

    public AbstractNamingString(String name, List<String> tokens) {
        this.source = name;
        this.tokens = tokens;
    }

    @Override
    public String convertTo(NamingStringEnum type) {
        switch (type) {
            case LOWER_CAMEL: {
                return this.convertLowerCamel();
            }
            case LOWER_HYPHEN: {
                return this.convertLowerHyphen();
            }
            case LOWER_UNDERSCORE: {
                return this.convertLowerUnderScore();
            }
            case UPPER_CAMEL: {
                return this.convertUpperCamel();
            }
            case UPPER_UNDERSCORE: {
                return this.convertUpperUnderScore();
            }
            case UNKNOWN: {
                return this.source;
            }
        }
        return null;
    }

    private String convertLowerCamel() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (i == 0) {
                builder.append(this.tokens.get(i));
                continue;
            }
            builder.append(this.upperFirst(this.tokens.get(i)));
        }
        return builder.toString();
    }

    private String convertLowerHyphen() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (i == 0) {
                builder.append(this.tokens.get(i));
                continue;
            }
            builder.append("-").append(this.tokens.get(i));
        }
        return builder.toString();
    }

    private String convertLowerUnderScore() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (i == 0) {
                builder.append(this.tokens.get(i));
                continue;
            }
            builder.append("_").append(this.tokens.get(i));
        }
        return builder.toString();
    }

    private String convertUpperCamel() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            builder.append(this.upperFirst(this.tokens.get(i)));
        }
        return builder.toString();
    }

    private String convertUpperUnderScore() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (i == 0) {
                builder.append(this.tokens.get(i).toUpperCase());
                continue;
            }
            builder.append("_").append(this.tokens.get(i).toUpperCase());
        }
        return builder.toString();
    }

    private String upperFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tokens == null ? 0 : this.tokens.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AbstractNamingString other = (AbstractNamingString)obj;
        return !(this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens));
    }

    public String toString() {
        return this.source;
    }
}

