/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.naming;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.naming.AbstractNamingString;
import org.tinygroup.tinyscript.naming.NamingString;
import org.tinygroup.tinyscript.naming.NamingStringEnum;

public final class NamingStringUtil {
    private NamingStringUtil() {
    }

    public static NamingString parse(String name) {
        char[] cs = name.toCharArray();
        int[] types = new int[cs.length];
        boolean unknown = false;
        int upperNum = 0;
        int lowerNum = 0;
        int enDishNum = 0;
        int underlineNUm = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (NamingStringUtil.isUpper(cs[i])) {
                types[i] = 1;
                ++upperNum;
                continue;
            }
            if (NamingStringUtil.isLower(cs[i])) {
                types[i] = 2;
                ++lowerNum;
                continue;
            }
            if (NamingStringUtil.isNumber(cs[i])) {
                types[i] = 3;
                continue;
            }
            if (cs[i] == '-') {
                types[i] = 4;
                ++enDishNum;
                continue;
            }
            if (cs[i] == '_') {
                types[i] = 5;
                ++underlineNUm;
                continue;
            }
            unknown = true;
            break;
        }
        if (!unknown) {
            if (lowerNum > 0 && types[0] == 2 && enDishNum == 0 && underlineNUm == 0) {
                List<String> tokens = NamingStringUtil.splitTokens(cs, types, 1, true);
                return new LowerCamelNamingString(name, tokens);
            }
            if (lowerNum > 0 && enDishNum > 0 && underlineNUm == 0) {
                List<String> tokens = NamingStringUtil.splitTokens(cs, types, 4, false);
                return new LowerHyphenNamingString(name, tokens);
            }
            if (lowerNum > 0 && enDishNum == 0 && underlineNUm > 0) {
                List<String> tokens = NamingStringUtil.splitTokens(cs, types, 5, false);
                return new LowerUnderScoreNamingString(name, tokens);
            }
            if (upperNum > 0 && types[0] == 1 && enDishNum == 0 && underlineNUm == 0) {
                if (lowerNum == 0) {
                    ArrayList<String> tokens = new ArrayList<String>();
                    tokens.add(name.toLowerCase());
                    return new UpperCamelNamingString(name, tokens);
                }
                List<String> tokens = NamingStringUtil.splitTokens(cs, types, 1, true);
                return new UpperCamelNamingString(name, tokens);
            }
            if (upperNum > 0 && enDishNum == 0 && underlineNUm > 0) {
                List<String> tokens = NamingStringUtil.splitTokens(cs, types, 5, false);
                return new UpperUnderScoreNamingString(name, tokens);
            }
        }
        return new UnKnownNamingString(name);
    }

    private static List<String> splitTokens(char[] cs, int[] types, int splitTag, boolean append) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == splitTag) {
                if (builder.length() > 0) {
                    tokens.add(builder.toString().toLowerCase());
                    builder = new StringBuilder();
                }
                if (!append) continue;
                builder.append(cs[i]);
                continue;
            }
            builder.append(cs[i]);
        }
        if (builder.length() > 0) {
            tokens.add(builder.toString().toLowerCase());
        }
        return tokens;
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    static class UnKnownNamingString
    extends AbstractNamingString {
        public UnKnownNamingString(String name) {
            super(name);
            this.tokens.add(name);
        }

        @Override
        public NamingStringEnum getType() {
            return NamingStringEnum.UNKNOWN;
        }
    }

    static class UpperUnderScoreNamingString
    extends AbstractNamingString {
        public UpperUnderScoreNamingString(String name, List<String> tokens) {
            super(name, tokens);
        }

        @Override
        public NamingStringEnum getType() {
            return NamingStringEnum.UPPER_UNDERSCORE;
        }
    }

    static class UpperCamelNamingString
    extends AbstractNamingString {
        public UpperCamelNamingString(String name, List<String> tokens) {
            super(name, tokens);
        }

        @Override
        public NamingStringEnum getType() {
            return NamingStringEnum.UPPER_CAMEL;
        }
    }

    static class LowerUnderScoreNamingString
    extends AbstractNamingString {
        public LowerUnderScoreNamingString(String name, List<String> tokens) {
            super(name, tokens);
        }

        @Override
        public NamingStringEnum getType() {
            return NamingStringEnum.LOWER_UNDERSCORE;
        }
    }

    static class LowerHyphenNamingString
    extends AbstractNamingString {
        public LowerHyphenNamingString(String name, List<String> tokens) {
            super(name, tokens);
        }

        @Override
        public NamingStringEnum getType() {
            return NamingStringEnum.LOWER_HYPHEN;
        }
    }

    static class LowerCamelNamingString
    extends AbstractNamingString {
        public LowerCamelNamingString(String name, List<String> tokens) {
            super(name, tokens);
        }

        @Override
        public NamingStringEnum getType() {
            return NamingStringEnum.LOWER_CAMEL;
        }
    }
}

