/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.objectitem;

import java.lang.reflect.Array;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.objectitem.ObjectItemProcessor;

public class ArrayItemProcessor
implements ObjectItemProcessor {
    @Override
    public boolean isMatch(Object obj, Object ... items) {
        return obj.getClass().isArray();
    }

    @Override
    public Object process(ScriptContext context, Object obj, Object ... items) throws Exception {
        return this.get(obj, 0, items);
    }

    @Override
    public void assignValue(ScriptContext context, Object value, Object obj, Object ... items) throws Exception {
        this.set(obj, value, 0, items);
    }

    private Object get(Object array, int dim, Object ... items) throws Exception {
        int n = ExpressionUtil.convertInteger(items[dim]);
        if (dim == items.length - 1) {
            return Array.get(array, n);
        }
        Object newArray = Array.get(array, n);
        return this.get(newArray, dim + 1, items);
    }

    private void set(Object array, Object value, int dim, Object ... items) throws Exception {
        int n = ExpressionUtil.convertInteger(items[dim]);
        if (dim == items.length - 1) {
            Array.set(array, n, value);
        } else {
            Object newArray = Array.get(array, n);
            this.set(newArray, value, dim + 1, items);
        }
    }
}

