/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.objectitem;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.objectitem.ArrayItemProcessor;
import org.tinygroup.tinyscript.objectitem.ListItemProcessor;
import org.tinygroup.tinyscript.objectitem.ObjectItemProcessor;

public class ObjectItemUtil {
    private static List<ObjectItemProcessor> processors = new ArrayList<ObjectItemProcessor>();

    public static void addObjectItemProcessor(ObjectItemProcessor processor) {
        for (ObjectItemProcessor objectItemProcessor : processors) {
            if (!objectItemProcessor.equals(processor) && !objectItemProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        processors.add(processor);
    }

    public static void addObjectItemProcessor(ObjectItemProcessor processor, int index) {
        for (ObjectItemProcessor objectItemProcessor : processors) {
            if (!objectItemProcessor.equals(processor) && !objectItemProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        processors.add(index, processor);
    }

    public static void removeObjectItemProcessor(ObjectItemProcessor processor) {
        processors.remove(processor);
    }

    public static Object operate(ScriptContext context, Object obj, Object ... items) throws Exception {
        for (ObjectItemProcessor processor : processors) {
            if (!processor.isMatch(obj, items)) continue;
            return processor.process(context, obj, items);
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("unmatch.info1", ObjectItemProcessor.class.getName()));
    }

    public static void assignValue(ScriptContext context, Object value, Object obj, Object ... items) throws Exception {
        boolean tag = false;
        for (ObjectItemProcessor processor : processors) {
            if (!processor.isMatch(obj, items)) continue;
            processor.assignValue(context, value, obj, items);
            tag = true;
            break;
        }
        if (!tag) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("unmatch.info1", ObjectItemProcessor.class.getName()));
        }
    }

    static {
        ObjectItemUtil.addObjectItemProcessor(new ArrayItemProcessor());
        ObjectItemUtil.addObjectItemProcessor(new ListItemProcessor());
    }
}

